/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.accumulator;

import com.mrh0.createaddition.blocks.accumulator.AccumulatorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.network.RemoveConnectorPacket;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import team.reborn.energy.api.EnergyStorage;

public class AccumulatorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IHaveGoggleInformation,
IComparatorOverride,
IObserveTileEntity {
    private final class_2338[] connectionPos;
    private final int[] connectionIndices;
    private final WireType[] connectionTypes;
    public IWireNode[] nodeCache;
    public static class_243 OFFSET_NORTH = new class_243(0.0, 0.5625, -0.3125);
    public static class_243 OFFSET_WEST = new class_243(-0.3125, 0.5625, 0.0);
    public static class_243 OFFSET_SOUTH = new class_243(0.0, 0.5625, 0.3125);
    public static class_243 OFFSET_EAST = new class_243(0.3125, 0.5625, 0.0);
    public static final int NODE_COUNT = 8;
    public static final long CAPACITY = (Long)Config.ACCUMULATOR_CAPACITY.get();
    public static final long MAX_IN = (Long)Config.ACCUMULATOR_MAX_INPUT.get();
    public static final long MAX_OUT = (Long)Config.ACCUMULATOR_MAX_OUTPUT.get();
    private int lastComparator = 0;
    private boolean firstTickState = true;
    private long demandOut = 0L;
    private long demandIn = 0L;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public AccumulatorTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, MAX_OUT);
        this.setLazyTickRate(20);
        this.connectionPos = new class_2338[this.getNodeCount()];
        this.connectionIndices = new int[this.getNodeCount()];
        this.connectionTypes = new WireType[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.field_11863, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public class_243 getNodeOffset(int node) {
        if (node > 3) {
            switch ((class_2350)this.method_11010().method_11654((class_2769)AccumulatorBlock.FACING)) {
                case field_11043: {
                    return OFFSET_NORTH;
                }
                case field_11039: {
                    return OFFSET_WEST;
                }
                case field_11035: {
                    return OFFSET_SOUTH;
                }
                case field_11034: {
                    return OFFSET_EAST;
                }
            }
        } else {
            switch ((class_2350)this.method_11010().method_11654((class_2769)AccumulatorBlock.FACING)) {
                case field_11043: {
                    return OFFSET_SOUTH;
                }
                case field_11039: {
                    return OFFSET_EAST;
                }
                case field_11035: {
                    return OFFSET_NORTH;
                }
                case field_11034: {
                    return OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isEnergyInput(class_2350 side) {
        return side != class_2350.field_11036;
    }

    @Override
    public boolean isEnergyOutput(class_2350 side) {
        return false;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getNodeFromPos(class_243 vec) {
        assert (this.field_11863 != null);
        class_2350 dir = (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AccumulatorBlock.FACING);
        boolean upper = true;
        vec = vec.method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        switch (dir) {
            case field_11043: {
                upper = vec.method_10215() < 0.5;
                break;
            }
            case field_11039: {
                upper = vec.method_10216() < 0.5;
                break;
            }
            case field_11035: {
                upper = vec.method_10215() > 0.5;
                break;
            }
            case field_11034: {
                upper = vec.method_10216() > 0.5;
                break;
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public class_2338 getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndices[node];
    }

    @Override
    public void setNode(int node, int other, class_2338 pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndices[node] = other;
        this.connectionTypes[node] = type;
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.method_5431();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public class_2338 getMyPos() {
        return this.field_11867;
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        int comp = this.getComparatorOverride();
        if (comp != this.lastComparator) {
            assert (this.field_11863 != null);
            this.field_11863.method_8452(this.field_11867, (class_2248)CABlocks.ACCUMULATOR.get());
        }
        this.lastComparator = comp;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        if (this.awakeNetwork(this.field_11863)) {
            this.causeBlockUpdate();
        }
        if (this.networkOut == null) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            long pull;
            long demand;
            try (Transaction nested = Transaction.openNested((TransactionContext)t);){
                demand = this.networkOut.push(this.energy.extract(this.demandOut, (TransactionContext)nested));
                pull = this.networkIn.pull(Math.min(this.demandIn, this.energy.insert(MAX_IN, (TransactionContext)nested)));
                this.demandIn = this.networkIn.demand(this.energy.insert(MAX_IN, (TransactionContext)nested));
            }
            this.energy.extract(demand, (TransactionContext)t);
            this.demandOut = this.networkOut.getDemand();
            this.energy.insert(pull, (TransactionContext)t);
            t.commit();
        }
    }

    public void onBlockRemoved() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            IWireNode node = this.getNode(i);
            if (node == null) break;
            int other = this.getOtherNodeIndex(i);
            node.removeNode(other);
            node.invalidateNodeCache();
            RemoveConnectorPacket.send(node.getMyPos(), other, this.field_11863);
        }
        this.invalidateNodeCache();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        this.method_11012();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndicesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void setEnergy(int energy) {
        this.energy.setEnergy(energy);
    }

    @Override
    public int getComparatorOverride() {
        return (int)((double)this.energy.getAmount() / (double)this.energy.getCapacity() * 15.0);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        class_239 ray = class_310.method_1551().field_1765;
        if (ray == null) {
            return false;
        }
        int node = this.getNodeFromPos(ray.method_17784());
        ObservePacket.send(this.field_11867, node);
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.accumulator.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.stored").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2585(" ")).method_10852(Util.getTextComponent((EnergyStorage)this.energy)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.selected").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)new class_2588(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output").method_27692(class_124.field_1075)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_27693(" ").method_27693(Util.format(EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return true;
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(pack.node()).getPulled(), this.getNetwork(pack.node()).getPushed(), player);
        }
        this.causeBlockUpdate();
    }
}

