/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.network.RemoveConnectorPacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import team.reborn.energy.api.EnergyStorage;

public class ConnectorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IObserveTileEntity,
IHaveGoggleInformation {
    private final class_2338[] connectionPos = new class_2338[this.getNodeCount()];
    private final int[] connectionIndices = new int[this.getNodeCount()];
    private final WireType[] connectionTypes = new WireType[this.getNodeCount()];
    public IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    public static class_243 OFFSET_DOWN = new class_243(0.0, -0.1875, 0.0);
    public static class_243 OFFSET_UP = new class_243(0.0, 0.1875, 0.0);
    public static class_243 OFFSET_NORTH = new class_243(0.0, 0.0, -0.1875);
    public static class_243 OFFSET_WEST = new class_243(-0.1875, 0.0, 0.0);
    public static class_243 OFFSET_SOUTH = new class_243(0.0, 0.0, 0.1875);
    public static class_243 OFFSET_EAST = new class_243(0.1875, 0.0, 0.0);
    public static final int NODE_COUNT = 4;
    public static final long CAPACITY = (Long)Config.CONNECTOR_CAPACITY.get();
    public static final long MAX_IN = (Long)Config.CONNECTOR_MAX_INPUT.get();
    public static final long MAX_OUT = (Long)Config.CONNECTOR_MAX_OUTPUT.get();
    private EnergyNetwork network;
    private long demand = 0L;

    public ConnectorTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, MAX_OUT);
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.field_11863, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public class_243 getNodeOffset(int node) {
        return switch ((class_2350)this.method_11010().method_11654((class_2769)ConnectorBlock.FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> OFFSET_DOWN;
            case class_2350.field_11036 -> OFFSET_UP;
            case class_2350.field_11043 -> OFFSET_NORTH;
            case class_2350.field_11039 -> OFFSET_WEST;
            case class_2350.field_11035 -> OFFSET_SOUTH;
            case class_2350.field_11034 -> OFFSET_EAST;
        };
    }

    @Override
    public boolean isEnergyInput(class_2350 side) {
        return this.method_11010().method_11654((class_2769)ConnectorBlock.FACING) == side;
    }

    @Override
    public boolean isEnergyOutput(class_2350 side) {
        return this.method_11010().method_11654((class_2769)ConnectorBlock.FACING) == side;
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public int getNodeFromPos(class_243 vector3d) {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public class_2338 getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndices[node];
    }

    @Override
    public void setNode(int node, int other, class_2338 pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndices[node] = other;
        this.connectionTypes[node] = type;
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.method_5431();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public class_2338 getMyPos() {
        return this.field_11867;
    }

    public void onBlockRemoved() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode node;
            if (this.getNodeType(i) == null || (node = this.getNode(i)) == null) continue;
            int other = this.getOtherNodeIndex(i);
            node.removeNode(other);
            node.invalidateNodeCache();
            RemoveConnectorPacket.send(node.getMyPos(), other, this.field_11863);
        }
        this.invalidateNodeCache();
        if (this.network != null) {
            this.network.invalidate();
        }
        this.method_11012();
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return;
        }
        if (this.awakeNetwork(this.field_11863)) {
            this.causeBlockUpdate();
        }
        this.networkTick(this.network);
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    private void networkTick(EnergyNetwork en) {
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return;
        }
        class_2350 d = (class_2350)this.method_11010().method_11654((class_2769)ConnectorBlock.FACING);
        EnergyStorage ies = this.getCachedEnergy(d);
        if (ies == null) {
            return;
        }
        long pull = en.pull(this.demand);
        try (Transaction t = Transaction.openOuter();){
            long testInsert;
            long testExtract;
            ies.insert(pull, (TransactionContext)t);
            try (Transaction nested = Transaction.openNested((TransactionContext)t);){
                testExtract = this.energy.extract(Long.MAX_VALUE, (TransactionContext)nested);
                testInsert = ies.insert(MAX_OUT, (TransactionContext)nested);
            }
            this.demand = en.demand(testInsert);
            long push = en.push(testExtract);
            this.energy.internalConsumeEnergy(push);
            t.commit();
        }
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.field_11867, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.field_11867, 0);
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.connector.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)new class_2585("    ").method_10852((class_2561)new class_2588("createaddition.tooltip.energy.usage").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)new class_2585("    ").method_27693(" ").method_27693(Util.format(EnergyNetworkPacket.clientBuff)).method_27693("fe/t").method_27692(class_124.field_1075));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

