/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.liquid_blaze_burner;

import com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurner;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.liquid_burning.FluidTagRecipeComparator;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class LiquidBlazeBurnerTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation,
IObserveTileEntity,
FluidTransferable {
    public static final int MAX_HEAT_CAPACITY = 10000;
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    protected LerpedFloat headAnimation = LerpedFloat.linear();
    protected LerpedFloat headAngle = LerpedFloat.angular();
    protected boolean isCreative = false;
    protected boolean goggles = false;
    protected boolean hat;
    protected FluidTank fluidTank;

    public LiquidBlazeBurnerTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((class_2350)state.method_28500((class_2769)LiquidBlazeBurner.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f));
        this.fluidTank = new FluidTank(324000L);
    }

    public void tick() {
        super.tick();
        assert (this.field_11863 != null);
        if (this.field_11863.field_9236) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock());
            }
            return;
        }
        this.burningTick();
        if (this.isCreative) {
            return;
        }
        FluidTagRecipeComparator.argsToTag(this.fluidTank.getFluid().getFluid(), (tagProperties, tagKey) -> this.setBurnTag((class_6862<class_3611>)tagKey, tagProperties.asResource(), tagProperties.getTime() / 100, tagProperties.getDropletAmount() / 100));
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = MAX_HEAT_CAPACITY / 2;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    private boolean setBurnTag(class_6862<class_3611> tagKey, class_2960 burnableTagLocation, int time, int fluidDropletAmount) {
        if (tagKey.comp_327().equals((Object)burnableTagLocation) && !Transaction.isOpen() && this.fluidTank.getFluidAmount() >= (long)fluidDropletAmount && this.remainingBurnTime <= 200) {
            Transaction transaction = Transaction.openOuter();
            this.fluidTank.extract((FluidVariant)this.fluidTank.variant, (long)fluidDropletAmount, (TransactionContext)transaction);
            transaction.commit();
            this.remainingBurnTime += time;
            this.activeFuel = FuelType.NORMAL;
            return true;
        }
        return false;
    }

    public void burningTick() {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.remainingBurnTime < 1) {
            return;
        }
        if (this.remainingBurnTime > MAX_HEAT_CAPACITY) {
            return;
        }
        this.activeFuel = FuelType.NORMAL;
        if (this.getHeatLevelFromBlock() != this.getHeatLevelFromBlock()) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 1.15f - this.field_11863.field_9229.nextFloat() * 0.25f);
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void tickAnimation() {
        boolean active;
        boolean bl = active = this.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_5767()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.method_23317();
                    z = player.method_23321();
                }
                double dx = x - ((double)this.method_11016().method_10263() + 0.5);
                double dz = z - ((double)this.method_11016().method_10260() + 0.5);
                target = AngleHelper.deg((double)(-class_3532.method_15349((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((class_2350)this.method_11010().method_28500((class_2769)LiquidBlazeBurner.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public void write(class_2487 compound, boolean clientPacket) {
        if (!this.isCreative) {
            compound.method_10569("fuelLevel", this.activeFuel.ordinal());
            compound.method_10569("burnTimeRemaining", this.remainingBurnTime);
        } else {
            compound.method_10556("isCreative", true);
        }
        if (this.goggles) {
            compound.method_10556("Goggles", true);
        }
        if (this.hat) {
            compound.method_10556("TrainHat", true);
        }
        compound.method_10566("TankContent", (class_2520)this.fluidTank.writeToNBT(new class_2487()));
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.activeFuel = FuelType.values()[compound.method_10550("fuelLevel")];
        this.remainingBurnTime = compound.method_10550("burnTimeRemaining");
        this.isCreative = compound.method_10577("isCreative");
        this.goggles = compound.method_10545("Goggles");
        this.hat = compound.method_10545("TrainHat");
        this.fluidTank.readFromNBT(compound.method_10562("TankContent"));
        super.read(compound, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf((class_2680)this.method_11010());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevelFromFuelType(this.activeFuel));
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        assert (this.field_11863 != null);
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(LiquidBlazeBurner.HEAT_LEVEL, (Comparable)heat));
        this.notifyUpdate();
    }

    private boolean tryUpdateLiquid(class_1799 ignoredItemStack, class_1657 player, class_1268 ignoredHand, Storage<FluidVariant> itemsFluidVariantStorage) {
        if (this.fluidTank.getFluidAmount() + 81000L > this.fluidTank.getCapacity()) {
            return false;
        }
        if (this.field_11863 == null) {
            return false;
        }
        return this.parseTaggedFluid(itemsFluidVariantStorage, player);
    }

    protected boolean tryUpdateFuel(class_1799 itemStack, boolean forceOverflow, boolean simulate, class_1657 player, class_1268 hand) {
        Integer newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        Storage itemsFluidVariantStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.withInitial((class_1799)itemStack));
        if (itemsFluidVariantStorage != null) {
            if (this.tryUpdateLiquid(itemStack, player, hand, (Storage<FluidVariant>)itemsFluidVariantStorage)) {
                return true;
            }
            if (this.doNotParseLava((Storage<FluidVariant>)itemsFluidVariantStorage)) {
                return false;
            }
        }
        if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.matches(itemStack)) {
            newBurnTime = 1000;
            newFuel = FuelType.SPECIAL;
        } else {
            FuelRegistry registry = FuelRegistry.INSTANCE;
            newBurnTime = (Integer)registry.get((class_1935)itemStack.method_7909());
            if (newBurnTime == null) {
                newBurnTime = 0;
            }
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.matches(itemStack)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (this.activeFuel == FuelType.SPECIAL && this.remainingBurnTime > 20) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime + newBurnTime > MAX_HEAT_CAPACITY && !forceOverflow) {
                return false;
            }
            newBurnTime = class_3532.method_15340((int)(this.remainingBurnTime + newBurnTime), (int)0, (int)MAX_HEAT_CAPACITY);
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        assert (this.field_11863 != null);
        if (this.field_11863.field_9236) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 1.15f - this.field_11863.field_9229.nextFloat() * 0.25f);
        }
        return true;
    }

    private Transaction getTransaction() {
        Transaction transaction = !Transaction.isOpen() ? Transaction.openOuter() : Transaction.getCurrentUnsafe().openNested();
        return transaction;
    }

    private boolean doNotParseLava(Storage<FluidVariant> itemsFluidVariantStorage) {
        Transaction transaction = this.getTransaction();
        Iterator iterator = itemsFluidVariantStorage.iterator((TransactionContext)transaction);
        while (iterator.hasNext()) {
            class_3611 fluid = ((FluidVariant)((StorageView)iterator.next()).getResource()).getFluid();
            if (fluid != class_3612.field_15907 && fluid != class_3612.field_15908) continue;
            transaction.commit();
            transaction.close();
            return true;
        }
        transaction.commit();
        transaction.close();
        return false;
    }

    private boolean parseTaggedFluid(Storage<FluidVariant> itemsFluidVariantStorage, class_1657 player) {
        Transaction transaction = this.getTransaction();
        Iterator iterator = itemsFluidVariantStorage.iterator((TransactionContext)transaction);
        while (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            class_3611 itemsFluid = ((FluidVariant)view.getResource()).getFluid();
            if (!FluidTagRecipeComparator.argsToTag(itemsFluid, (tagProperties, tagKey) -> {
                if (tagKey.comp_327().equals((Object)tagProperties.asResource()) && tagProperties.getTime() >= 100 && (this.fluidTank.getAmount() == 0L || this.fluidTank.getFluid().getFluid() == itemsFluid)) {
                    this.fluidTank.setFluid(new FluidStack(itemsFluid, this.fluidTank.getAmount() + (long)tagProperties.getDropletAmount()));
                    this.field_11863.method_8396(player, this.method_11016(), class_3417.field_14834, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 0.75f - this.field_11863.field_9229.nextFloat() * 0.25f);
                    if (this.field_11863.field_9236) {
                        this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
                    }
                    this.playSound();
                    this.field_11863.method_8396(player, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 1.15f - this.field_11863.field_9229.nextFloat() * 0.25f);
                    return true;
                }
                return null;
            })) continue;
            transaction.commit();
            transaction.close();
            return true;
        }
        transaction.commit();
        transaction.close();
        return false;
    }

    public boolean isValidBlockAbove() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10084());
        return AllBlocks.BASIN.has(blockState) || blockState.method_26204() instanceof FluidTankBlock;
    }

    protected void playSound() {
        assert (this.field_11863 != null);
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14970, class_3419.field_15245, 0.125f + this.field_11863.field_9229.nextFloat() * 0.125f, 0.75f - this.field_11863.field_9229.nextFloat() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevelFromFuelType(FuelType ignoredFuel) {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel) {
            case SPECIAL: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case NORMAL: {
                boolean lowPercent = (double)this.remainingBurnTime / (double)MAX_HEAT_CAPACITY < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
                break;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel) {
        if (this.field_11863 == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        Random r = this.field_11863.method_8409();
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_243 v = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (Random)r, (float)0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.nextInt(3) == 0) {
            this.field_11863.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        if (r.nextInt(2) != 0) {
            return;
        }
        boolean empty = this.field_11863.method_8320(this.field_11867.method_10084()).method_26220((class_1922)this.field_11863, this.field_11867.method_10084()).method_1110();
        double yMotion = empty ? 0.0625 : r.nextDouble() * (double)0.0125f;
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (Random)r, (float)0.5f).method_18805(1.0, 0.25, 1.0).method_1029().method_1021((empty ? 0.25 : 0.5) + r.nextDouble() * 0.125)).method_1031(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_22246, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_11240, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        assert (this.field_11863 != null);
        Random r = this.field_11863.field_9229;
        for (int i = 0; i < 20; ++i) {
            class_243 offset = VecHelper.offsetRandomly((class_243)class_243.field_1353, (Random)r, (float)0.5f).method_18805(1.0, 0.25, 1.0).method_1029();
            class_243 v = c.method_1019(offset.method_1021(0.5 + r.nextDouble() * 0.125)).method_1031(0.0, 0.125, 0.0);
            class_243 m = offset.method_1021(0.03125);
            this.field_11863.method_8406((class_2394)(soulFlame ? class_2398.field_22246 : class_2398.field_11240), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        return this.fluidTank;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.field_11867, 0);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (Storage)this.fluidTank);
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        this.causeBlockUpdate();
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

