/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.tesla_coil;

import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoil;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBeltCallbacks;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.DamageSourceAccessor;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class TeslaCoilTileEntity
extends BaseElectricTileEntity
implements IHaveGoggleInformation {
    private Optional<ChargingRecipe> recipeCache;
    private final ItemStackHandler inputInv = new ItemStackHandler(1);
    private int chargeAccumulator;
    private static final long MAX_IN = (Long)Config.TESLA_COIL_MAX_INPUT.get();
    private static final long CHARGE_RATE = (Long)Config.TESLA_COIL_CHARGE_RATE.get();
    private static final long CHARGE_RATE_RECIPE = (Long)Config.TESLA_COIL_RECIPE_CHARGE_RATE.get();
    private static final long CAPACITY = Math.max((Long)Config.TESLA_COIL_CAPACITY.get(), CHARGE_RATE);
    private static final long HURT_ENERGY_REQUIRED = ((Integer)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get()).intValue();
    private static final long HURT_DMG_MOB = ((Integer)Config.TESLA_COIL_HURT_DMG_MOB.get()).intValue();
    private static final long HURT_DMG_PLAYER = ((Integer)Config.TESLA_COIL_HURT_DMG_PLAYER.get()).intValue();
    private static final long HURT_RANGE = ((Integer)Config.TESLA_COIL_HURT_RANGE.get()).intValue();
    private static final long HURT_EFFECT_TIME_MOB = ((Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_MOB.get()).intValue();
    private static final long HURT_EFFECT_TIME_PLAYER = ((Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_PLAYER.get()).intValue();
    private static final long HURT_FIRE_COOLDOWN = ((Integer)Config.TESLA_COIL_HURT_FIRE_COOLDOWN.get()).intValue();
    protected int poweredTimer = 0;
    private static final class_1282 dmgSource = DamageSourceAccessor.port_lib$init((String)"tesla_coil");
    public BeltProcessingBehaviour processingBehaviour;
    int dmgTick = 0;

    public TeslaCoilTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, 0L);
        this.recipeCache = Optional.empty();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartTileEntity)this).whenItemEnters((s, i) -> TeslaCoilBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> TeslaCoilBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((TileEntityBehaviour)this.processingBehaviour);
    }

    @Override
    public boolean isEnergyInput(class_2350 side) {
        return side != ((class_2350)this.method_11010().method_11654((class_2769)TeslaCoil.FACING)).method_10153();
    }

    @Override
    public boolean isEnergyOutput(class_2350 side) {
        return false;
    }

    public long getConsumption() {
        return CHARGE_RATE;
    }

    protected BeltProcessingBehaviour.ProcessingResult onCharge(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        return this.chargeCompundAndStack(transported, handler);
    }

    private void doDmg() {
        this.energy.internalConsumeEnergy(HURT_ENERGY_REQUIRED);
        class_2338 origin = this.method_11016().method_10093(((class_2350)this.method_11010().method_11654((class_2769)TeslaCoil.FACING)).method_10153());
        List ents = Objects.requireNonNull(this.method_10997()).method_18467(class_1309.class, new class_238(origin).method_1014((double)HURT_RANGE));
        for (class_1309 e : ents) {
            long dmg = HURT_DMG_MOB;
            long time = HURT_EFFECT_TIME_MOB;
            if (e instanceof class_1657) {
                dmg = HURT_DMG_PLAYER;
                time = HURT_EFFECT_TIME_PLAYER;
            }
            if (dmg > 0L) {
                e.method_5643(dmgSource, (float)dmg);
            }
            if (time <= 0L) continue;
            e.method_6092(new class_1293(CAEffects.SHOCKING, (int)time));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            return;
        }
        int signal = Objects.requireNonNull(this.method_10997()).method_8482(this.method_11016());
        if (signal > 0 && this.energy.getAmount() >= HURT_ENERGY_REQUIRED) {
            this.poweredTimer = 10;
        }
        ++this.dmgTick;
        this.dmgTick = (int)((long)this.dmgTick % HURT_FIRE_COOLDOWN);
        if (this.dmgTick == 0 && this.energy.getAmount() >= HURT_ENERGY_REQUIRED && signal > 0) {
            this.doDmg();
        }
        if (this.poweredTimer > 0) {
            if (!this.isPoweredState()) {
                ((TeslaCoil)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.field_11863, this.method_11016(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((TeslaCoil)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.field_11863, this.method_11016(), false);
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.method_11010().method_11654((class_2769)TeslaCoil.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult chargeCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        class_1799 stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.chargeStack(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.chargeRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    protected final boolean chargeStack(class_1799 stack, TransportedItemStack ignoredTransported, TransportedItemStackHandlerBehaviour ignoredHandler) {
        String energyTag = "energy";
        EnergyStorage itemEnergy = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
        if (itemEnergy == null) {
            return false;
        }
        if (stack.method_7969() == null) {
            stack.method_7980(new class_2487());
        }
        if (EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
            block12: {
                if (this.energy.getAmount() < (long)stack.method_7947()) {
                    return false;
                }
                try (Transaction t = TransferUtil.getTransaction();){
                    long amountToUse = Math.min(this.getConsumption(), this.energy.getAmount());
                    class_2487 compoundTag = stack.method_7969();
                    double energyAmount = compoundTag.method_10574("energy");
                    long energyCapacity = itemEnergy.getCapacity();
                    double newAmount = energyAmount + (double)amountToUse;
                    if (newAmount < (double)itemEnergy.getCapacity()) {
                        this.energy.internalConsumeEnergy(itemEnergy.insert(amountToUse, (TransactionContext)t));
                        compoundTag.method_10566("energy", (class_2520)class_2489.method_23241((double)newAmount));
                        t.commit();
                        break block12;
                    }
                    if (energyAmount < (double)energyCapacity) {
                        long energyDiff = energyCapacity - (long)energyAmount;
                        System.out.println(energyDiff);
                        this.energy.internalConsumeEnergy(itemEnergy.insert(energyDiff, (TransactionContext)t));
                        compoundTag.method_10566("energy", (class_2520)class_2489.method_23241((double)(energyAmount + (double)energyDiff)));
                        t.commit();
                        break block12;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        return false;
    }

    private boolean chargeRecipe(class_1799 stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!this.inputInv.getStackInSlot(0).method_7962(stack)) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper(this.inputInv), Objects.requireNonNull(this.method_10997()));
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            ChargingRecipe recipe = this.recipeCache.get();
            long energyRemoved = this.energy.internalConsumeEnergy(Math.min(CHARGE_RATE_RECIPE, (long)(recipe.getEnergy() - this.chargeAccumulator)));
            this.chargeAccumulator = (int)((long)this.chargeAccumulator + energyRemoved);
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                TransportedItemStack left = transported.copy();
                left.stack.method_7934(1);
                ArrayList<TransportedItemStack> r = new ArrayList<TransportedItemStack>();
                r.add(new TransportedItemStack(recipe.method_8110().method_7972()));
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(r, (TransportedItemStack)left));
                this.chargeAccumulator = 0;
            }
            return true;
        }
        return false;
    }

    public Optional<ChargingRecipe> find(RecipeWrapper wrapper, class_1937 world) {
        return world.method_8433().method_8132(ChargingRecipe.TYPE, (class_1263)wrapper, world);
    }
}

