/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.configs;

import evergoodteam.chassis.configs.ConfigBuilder;
import evergoodteam.chassis.configs.ConfigHandler;
import evergoodteam.chassis.util.Reference;
import evergoodteam.chassis.util.handlers.DirHandler;
import evergoodteam.chassis.util.handlers.FileHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(Reference.CMI + "/Config"));
    public static final Map<String, ConfigBase> CONFIGURATIONS = new HashMap<String, ConfigBase>();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    public String namespace;
    public Path dirPath;
    public Path propertiesPath;
    public File propertiesFile;
    public Boolean configLocked = false;
    public Map<String, Object> resourcesLocked;
    public Map<String, Object> addonOptions;
    public List<String> addonComments;
    public ConfigBuilder builder;

    public ConfigBase(String namespace) {
        this.namespace = namespace;
        this.dirPath = CONFIG_DIR.resolve(namespace);
        this.propertiesPath = this.dirPath.resolve(namespace + ".properties");
        this.propertiesFile = new File(this.propertiesPath.toString());
        CONFIGURATIONS.put(namespace, this);
        this.resourcesLocked = new HashMap<String, Object>();
        this.addonOptions = new LinkedHashMap<String, Object>();
        this.addonComments = new ArrayList<String>();
        this.builder = new ConfigBuilder(this);
        ConfigHandler.readOptions(this);
        if (!this.configLocked.booleanValue()) {
            this.configLocked = true;
            this.createConfigRoot();
        } else {
            LOGGER.info("Configs for \"{}\" already exist, skipping first generation", (Object)this.namespace);
        }
    }

    @Nullable
    public static ConfigBase getConfig(String namespace) {
        return CONFIGURATIONS.containsKey(namespace) ? CONFIGURATIONS.get(namespace) : null;
    }

    private ConfigBase createConfigRoot() {
        FileHandler.delete(this.propertiesPath);
        DirHandler.create(this.dirPath);
        FileHandler.createFile(this.propertiesPath);
        this.builder.setupDefaultProperties();
        LOGGER.info("Generated Configs for \"{}\"", (Object)this.namespace);
        return this;
    }

    public ConfigBase addProperty(String name, Object value, @NotNull String comment) {
        this.addonOptions.put(name, value);
        this.addonComments.add(comment);
        return this;
    }

    public ConfigBase addProperty(String name, Object value) {
        this.addonOptions.put(name, value);
        this.addonComments.add("");
        return this;
    }

    public ConfigBase registerProperties() {
        this.builder.registerProperties();
        return this;
    }

    public ConfigBase overwrite(String name, String newValue) {
        this.builder.overwrite(name, newValue);
        return this;
    }

    public ConfigBase openConfigFile() {
        class_156.method_668().method_672(this.propertiesFile);
        return this;
    }
}

