/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.configs;

import evergoodteam.chassis.configs.ConfigBase;
import evergoodteam.chassis.configs.ConfigHandler;
import evergoodteam.chassis.util.Reference;
import evergoodteam.chassis.util.SetUtils;
import evergoodteam.chassis.util.StringUtils;
import evergoodteam.chassis.util.handlers.FileHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(Reference.CMI + "/C/B"));
    private final String NL = System.lineSeparator();
    private ConfigBase config;
    private Path path;
    private File file;

    public ConfigBuilder(@NotNull ConfigBase config) {
        this.config = config;
        this.path = config.propertiesPath;
        this.file = config.propertiesFile;
    }

    public void setupDefaultProperties() {
        FileOutputStream pos;
        try {
            pos = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(pos));
        try {
            bw.write(this.header());
            bw.write(this.defaultOptions());
            bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setupResourceProperties() {
        try {
            FileWriter fw = new FileWriter(this.file, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(this.resourceOptions());
            bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerProperties() {
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                String additional = this.additionalOptions();
                if (!additional.isEmpty()) {
                    FileWriter fw = new FileWriter(this.file, true);
                    BufferedWriter bw = new BufferedWriter(fw);
                    String original = Files.readString(this.path).strip();
                    new FileWriter(this.file, false).close();
                    bw.write(original);
                    bw.write(System.lineSeparator());
                    bw.write(additional);
                    bw.close();
                    this.updateHeader();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void overwrite(String name, String newValue) {
        Properties config = new Properties();
        try (FileInputStream input = new FileInputStream(this.file);){
            config.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String oldValue = config.getProperty(name);
        if (oldValue != null) {
            try {
                String file = Files.readString(this.path);
                file = file.replace(name + " = " + oldValue, name + " = " + newValue);
                FileHandler.writeToFile(file, this.path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void updateHeader() {
        if (Files.exists(this.path, new LinkOption[0])) {
            List<String> contents = ConfigHandler.getContents(this.config);
            FileHandler.emptyFile(this.file);
            try {
                FileWriter fw = new FileWriter(this.file, true);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(this.header());
                for (int i = 2; i < contents.size(); ++i) {
                    if (i == 2) {
                        bw.write(contents.get(i).strip());
                        continue;
                    }
                    bw.write(contents.get(i));
                    bw.write(System.lineSeparator());
                }
                bw.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String header() {
        String result = "# %s Configs".formatted(StringUtils.capitalize(this.config.namespace)) + this.NL + "# " + new Date() + this.NL + this.NL;
        return result;
    }

    public String header(String text) {
        String line = "#".repeat(81);
        String result = line + this.NL + "# " + text + this.NL + line + this.NL + this.NL;
        return result;
    }

    public String defaultOptions() {
        String result = "# Lock " + StringUtils.capitalize(this.config.namespace) + " configs from being regenerated" + this.NL + this.config.namespace + "ConfigLocked = " + this.config.configLocked + this.NL;
        return result;
    }

    public String resourceOptions() {
        StringBuilder sb = new StringBuilder();
        sb.append("# Lock " + StringUtils.capitalize(this.config.namespace) + " resources from being regenerated" + this.NL);
        this.config.resourcesLocked.forEach((name, value) -> sb.append(name + " = " + value + this.NL));
        sb.append(this.NL);
        return sb.toString();
    }

    public String additionalOptions() {
        StringBuilder sb = new StringBuilder();
        Properties p = new Properties();
        try (FileInputStream input = new FileInputStream(this.config.propertiesFile);){
            p.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.config.addonOptions.forEach((name, value) -> {
            int index = SetUtils.getIndex(this.config.addonOptions.keySet(), name);
            if (p.getProperty((String)name) == null) {
                if (!"".equals(this.config.addonComments.get(index))) {
                    sb.append(this.NL + "# " + this.config.addonComments.get(index) + this.NL);
                } else {
                    sb.append(this.NL);
                }
                sb.append(name + " = " + value);
            } else {
                this.config.addonOptions.put((String)name, p.getProperty((String)name));
            }
        });
        return sb.toString();
    }
}

