/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.configs;

import evergoodteam.chassis.configs.ConfigBase;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"chassis/C/H");

    public static List<String> getContents(@NotNull ConfigBase config) {
        try {
            return Files.readAllLines(config.propertiesPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readOptions(@NotNull ConfigBase config) {
        if (Files.exists(config.propertiesPath, new LinkOption[0])) {
            Properties c = new Properties();
            try (FileInputStream input = new FileInputStream(config.propertiesFile);){
                c.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (c.isEmpty()) {
                LOGGER.warn("Can't read as the Config File is empty, trying to regenerate");
                config.builder.setupDefaultProperties();
            }
            config.configLocked = ConfigHandler.getBooleanOption(config, config.namespace + "ConfigLocked", false);
            config.resourcesLocked.forEach((name, value) -> config.resourcesLocked.put((String)name, ConfigHandler.getOption(config, name, value)));
            config.addonOptions.forEach((name, value) -> config.addonOptions.put((String)name, ConfigHandler.getOption(config, name, value)));
        }
    }

    @NotNull
    public static Boolean getBooleanOption(@NotNull ConfigBase config, String name, Boolean defaultValue) {
        return Boolean.valueOf(String.valueOf(ConfigHandler.getOption(config, name, defaultValue)));
    }

    public static Object getOption(@NotNull ConfigBase config, String name, Object defaultValue) {
        return ConfigHandler.getOption(config, name) != null ? ConfigHandler.getOption(config, name) : defaultValue;
    }

    @Nullable
    public static Object getOption(@NotNull ConfigBase config, String name) {
        Properties p = new Properties();
        if (Files.exists(config.propertiesPath, new LinkOption[0])) {
            try (FileInputStream input = new FileInputStream(config.propertiesFile);){
                p.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return p.getProperty(name);
    }
}

