/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.mixin;

import com.google.gson.JsonObject;
import evergoodteam.chassis.objects.assets.ModelJson;
import evergoodteam.chassis.util.IdentifierParser;
import evergoodteam.chassis.util.Reference;
import evergoodteam.chassis.util.handlers.RegistryHandler;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1088.class})
public class ModelLoaderMixin {
    @Inject(method={"loadModelFromJson"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceManager;getResource(Lnet/minecraft/util/Identifier;)Lnet/minecraft/resource/Resource;")}, cancellable=true)
    public void loadModelFromJson(class_2960 id, CallbackInfoReturnable<class_793> cir) {
        if (Reference.MODEL_INJECTION.isEmpty()) {
            return;
        }
        for (int i = 0; i < Reference.MODEL_INJECTION.size(); ++i) {
            if (Reference.MODEL_INJECTION.contains(id.method_12836())) continue;
            return;
        }
        String entryNamespace = id.method_12836();
        String entryPath = IdentifierParser.getIdFromIdentifier(id);
        JsonObject modelJson = new JsonObject();
        if ("block".equals(IdentifierParser.getTypeFromIdentifier(id))) {
            modelJson = Reference.COLUMNS.stream().anyMatch(entryPath::contains) ? ModelJson.createBlockModelJson("column", id.toString()) : ModelJson.createBlockModelJson("all", id.toString());
        } else if ("item".equals(IdentifierParser.getTypeFromIdentifier(id))) {
            if (RegistryHandler.REGISTERED_BLOCKS.get(id.method_12836()).contains(entryPath)) {
                modelJson = ModelJson.createItemModelJson(entryNamespace, "block", entryPath);
            } else if (RegistryHandler.ITEM_TYPES.get("generated").contains(IdentifierParser.getString(entryNamespace, entryPath))) {
                modelJson = ModelJson.createItemModelJson(entryNamespace, "generated", entryPath);
            } else if (RegistryHandler.ITEM_TYPES.get("handheld").contains(IdentifierParser.getString(entryNamespace, entryPath))) {
                modelJson = ModelJson.createItemModelJson(entryNamespace, "handheld", entryPath);
            }
        } else {
            return;
        }
        if (modelJson == null) {
            return;
        }
        class_793 model = class_793.method_3430((String)modelJson.toString());
        model.field_4252 = id.toString();
        cir.setReturnValue((Object)model);
    }
}

