/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import evergoodteam.chassis.util.Reference;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(Reference.CMI + "/U/Json"));

    public static JsonObject getJsonObject(@NotNull Path file) {
        JsonElement jsonElement = null;
        try {
            jsonElement = JsonParser.parseReader((Reader)new FileReader(file.toString()));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File not found", (Throwable)e);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return jsonObject;
    }

    public static JsonObject getJsonObject(@NotNull String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }

    public static String getString(@NotNull JsonObject jsonObject) {
        return jsonObject.toString();
    }
}

