/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.util.handlers;

import evergoodteam.chassis.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"chassis/H/File");

    public static void emptyFile(Path path) {
        FileHandler.emptyFile(path.toFile());
    }

    public static void emptyFile(File file) {
        if (file.exists()) {
            try {
                new FileWriter(file, false).close();
            }
            catch (IOException e) {
                LOGGER.error("Error on emptying File at {}", (Object)file.getPath(), (Object)e);
            }
        } else {
            LOGGER.warn("Provided Path is not valid: {}", (Object)file.getPath());
        }
    }

    public static void writeToFile(String text, Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try (FileWriter fileWriter = new FileWriter(path.toFile());){
                fileWriter.write(text);
            }
            catch (IOException e) {
                LOGGER.error("Error on writing to File at {}", (Object)path, (Object)e);
            }
        } else {
            LOGGER.warn("Provided Path is not valid: {}", (Object)path);
        }
    }

    public static void createJsonFile(Path path) {
        Path actual = StringUtils.checkDuplicateExtension(path, ".json");
        FileHandler.createFile(actual, ".json");
    }

    public static void createFile(Path path, String extension) {
        Path actual = StringUtils.checkDuplicateExtension(path, extension);
        FileHandler.createFile(Paths.get(actual + extension, new String[0]));
    }

    public static void createFile(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Error on creating File at {}", (Object)path, (Object)e);
            }
        }
    }

    public static void delete(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                FileUtils.delete((File)path.toFile());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error on deleting File at {}", (Object)path, (Object)e);
        }
    }
}

