/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify;

import com.github.zafarkhaja.semver.Version;
import dev.isxander.debugify.api.updater.UpdateChecker;
import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.utils.ClientUtils;
import dev.isxander.debugify.utils.Loader;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debugify {
    public static Logger logger = LoggerFactory.getLogger((String)"Debugify");
    public static Version version = Version.valueOf("1.11.0");
    public static DebugifyConfig config = new DebugifyConfig();
    public static boolean configWasDirty = false;

    public static void onPreInitialize() {
        config.preload();
    }

    public static void onInitialize() {
        boolean bl = configWasDirty = !config.doesJsonHaveIdenticalKeys();
        if (configWasDirty) {
            logger.info("Saving config because the loaded bug fixes are different to stored json.");
            config.save();
        }
        CompletableFuture.runAsync(() -> {
            if (!Debugify.config.optOutUpdater) {
                Version latestVersion = UpdateChecker.getLatestVersion();
                if (latestVersion == null) {
                    return;
                }
                if (latestVersion.compareTo(version) > 0) {
                    logger.info("An update is available! You're on {} but the latest is {}!", (Object)version, (Object)latestVersion);
                }
            }
        });
        logger.info("Successfully Debugify'd your game!");
        logger.info("Proudly fixes {} bugs!", (Object)config.getBugFixes().values().stream().filter(enabled -> enabled).count());
    }

    public static boolean isGameplayFixesEnabled() {
        if (Loader.getEnv() == BugFix.Env.CLIENT && ClientUtils.isInMultiplayerWorld()) {
            return Debugify.config.gameplayFixesInMultiplayer;
        }
        return true;
    }
}

