/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.utils.ExpectUtils;
import dev.isxander.debugify.utils.Loader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class BugFixDescriptionCache {
    private static final Path file = ExpectUtils.getConfigPath().resolve("debugify-descriptions.json");
    private static final Gson gson = new Gson();
    private final Map<String, String> descriptionHolder = new HashMap<String, String>();
    private final String url = "https://bugs.mojang.com/rest/api/2/issue/%s";

    private void cacheDescriptions() {
        Debugify.logger.info("Caching bug descriptions");
        HttpClient client = HttpClient.newHttpClient();
        for (BugFixData bugData : Debugify.config.getBugFixes().keySet()) {
            String id = bugData.bugId();
            try {
                HttpRequest request = HttpRequest.newBuilder(new URI(String.format("https://bugs.mojang.com/rest/api/2/issue/%s", id))).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    Debugify.logger.error("Description Cache: {} - {}", (Object)response.statusCode(), (Object)response.body());
                    continue;
                }
                JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
                JsonObject fields = json.getAsJsonObject("fields");
                String summary = fields.get("summary").getAsString();
                this.descriptionHolder.put(id, Loader.getLoader() != Loader.FABRIC || !ExpectUtils.isModLoaded("tooltipfix") ? this.wrapTextLenient(summary, 50) : summary);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void trySave() {
        Debugify.logger.info("Saving Description Cache...");
        if (this.descriptionHolder.isEmpty()) {
            Debugify.logger.info("Cache empty. Getting descriptions and saving in a new thread.");
            CompletableFuture.runAsync(() -> {
                this.cacheDescriptions();
                this.save();
            });
            return;
        }
        this.save();
    }

    private void save() {
        try {
            Files.deleteIfExists(file);
            JsonObject json = new JsonObject();
            this.descriptionHolder.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            Files.createFile(file, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean load() {
        Debugify.logger.info("Loading Description Cache");
        if (!Files.exists(file, new LinkOption[0])) {
            return false;
        }
        try {
            String jsonString = Files.readString(file);
            JsonObject json = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
            Map<String, String> loadedDescriptions = json.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.descriptionHolder.putAll(loadedDescriptions);
        }
        catch (Exception e) {
            Debugify.logger.error("Couldn't load description cache! Attempting to save.");
            e.printStackTrace();
            this.trySave();
            return false;
        }
        return true;
    }

    public String get(String id) {
        return this.descriptionHolder.get(id);
    }

    public boolean has(String id) {
        return this.descriptionHolder.containsKey(id);
    }

    private String wrapTextLenient(String text, int charLength) {
        StringBuilder sb = new StringBuilder();
        int lineLength = 0;
        boolean needsLineBreak = false;
        for (char c : text.toCharArray()) {
            ++lineLength;
            if (c == '\n') {
                lineLength = 0;
            }
            if (lineLength > charLength) {
                needsLineBreak = true;
            }
            if (needsLineBreak && c == ' ') {
                lineLength = 0;
                sb.append('\n');
                needsLineBreak = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

