/*
 * Decompiled with CFR 0.152.
 */
package me.sargunvohra.mcmods.autoconfig1u;

import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.ConfigHolder;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.event.ConfigSerializeEvent;
import me.sargunvohra.mcmods.autoconfig1u.serializer.ConfigSerializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1269;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ConfigManager<T extends ConfigData>
implements ConfigHolder<T> {
    private final Logger logger;
    private final Config definition;
    private final Class<T> configClass;
    private final ConfigSerializer<T> serializer;
    private final Event<ConfigSerializeEvent.Save<T>> saveEvent = EventFactory.createArrayBacked(ConfigSerializeEvent.Save.class, listeners -> (config, data) -> {
        for (ConfigSerializeEvent.Save listener : listeners) {
            class_1269 result = listener.onSave(config, data);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    private final Event<ConfigSerializeEvent.Load<T>> loadEvent = EventFactory.createArrayBacked(ConfigSerializeEvent.Load.class, listeners -> (config, newData) -> {
        for (ConfigSerializeEvent.Load listener : listeners) {
            class_1269 result = listener.onLoad(config, newData);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    private T config;

    ConfigManager(Config definition, Class<T> configClass, ConfigSerializer<T> serializer) {
        this.logger = LogManager.getLogger();
        this.definition = definition;
        this.configClass = configClass;
        this.serializer = serializer;
        if (this.load()) {
            this.save();
        }
    }

    public Config getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public ConfigSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public void save() {
        if (((ConfigSerializeEvent.Save)this.saveEvent.invoker()).onSave(this, this.config) == class_1269.field_5814) {
            return;
        }
        try {
            this.serializer.serialize(this.config);
        }
        catch (ConfigSerializer.SerializationException e) {
            this.logger.error("Failed to save config '{}'", this.configClass, (Object)e);
        }
    }

    @Override
    public boolean load() {
        try {
            T deserialized = this.serializer.deserialize();
            class_1269 result = ((ConfigSerializeEvent.Load)this.loadEvent.invoker()).onLoad(this, deserialized);
            if (result == class_1269.field_5814) {
                this.config = this.serializer.createDefault();
                this.config.validatePostLoad();
                return false;
            }
            this.config = deserialized;
            this.config.validatePostLoad();
            return true;
        }
        catch (ConfigData.ValidationException | ConfigSerializer.SerializationException e) {
            this.logger.error("Failed to load config '{}', using default!", this.configClass, (Object)e);
            this.config = this.serializer.createDefault();
            try {
                this.config.validatePostLoad();
            }
            catch (ConfigData.ValidationException v) {
                throw new RuntimeException("result of createDefault() was invalid!", v);
            }
            return false;
        }
    }

    @Override
    public T getConfig() {
        return this.config;
    }

    @Override
    public void registerLoadListener(ConfigSerializeEvent.Load<T> load) {
        this.loadEvent.register(load);
    }

    @Override
    public void registerSaveListener(ConfigSerializeEvent.Save<T> save) {
        this.saveEvent.register(save);
    }
}

