/*
 * Decompiled with CFR 0.152.
 */
package me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonArray;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonElement;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonGrammar;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonNull;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonObject;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.JsonPrimitive;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.impl.DeserializationException;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.impl.Marshaller;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.magic.TypeMagic;

public class POJODeserializer {
    public static void unpackObject(Object target, JsonObject source) {
        try {
            POJODeserializer.unpackObject(target, source, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void unpackObject(Object target, JsonObject source, boolean failFast) throws DeserializationException {
        int modifiers;
        JsonObject work = source.clone();
        for (Field f : target.getClass().getDeclaredFields()) {
            modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            POJODeserializer.unpackField(target, f, work, failFast);
        }
        for (Field f : target.getClass().getFields()) {
            modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            POJODeserializer.unpackField(target, f, work, failFast);
        }
        if (!work.isEmpty() && failFast) {
            throw new DeserializationException("There was data that couldn't be applied to the destination object: " + work.toJson(JsonGrammar.STRICT));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unpackField(Object parent, Field f, JsonObject source, boolean failFast) throws DeserializationException {
        if (!source.containsKey(f.getName())) return;
        JsonElement elem = source.get(f.getName());
        source.remove(f.getName());
        if (elem == null || elem == JsonNull.INSTANCE) {
            boolean accessible = f.isAccessible();
            if (!accessible) {
                f.setAccessible(true);
            }
            try {
                f.set(parent, null);
                if (accessible) return;
                f.setAccessible(false);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                if (!failFast) return;
                throw new DeserializationException("Couldn't set field \"" + f.getName() + "\" of class \"" + parent.getClass().getCanonicalName() + "\"", ex);
            }
        }
        try {
            POJODeserializer.unpackFieldData(parent, f, elem, source.getMarshaller());
            return;
        }
        catch (Throwable t) {
            if (!failFast) return;
            throw new DeserializationException("There was a problem unpacking field " + f.getName() + " of class " + parent.getClass().getCanonicalName(), t);
        }
    }

    @Nullable
    public static Object Unpack(Type t, JsonElement elem, Marshaller marshaller) {
        Class<?> rawClass = TypeMagic.classForType(t);
        if (rawClass.isPrimitive()) {
            return null;
        }
        if (elem == null) {
            return null;
        }
        return null;
    }

    public static boolean unpackFieldData(Object parent, Field field, JsonElement elem, Marshaller marshaller) throws Throwable {
        if (elem == null) {
            return true;
        }
        try {
            field.setAccessible(true);
        }
        catch (Throwable t) {
            return false;
        }
        if (elem == JsonNull.INSTANCE) {
            field.set(parent, null);
            return true;
        }
        Class<?> fieldClass = field.getType();
        if (!POJODeserializer.isCollections(fieldClass)) {
            Object result = marshaller.marshall(fieldClass, elem);
            field.set(parent, result);
            return true;
        }
        if (field.get(parent) == null) {
            Object fieldValue = TypeMagic.createAndCast(field.getGenericType());
            if (fieldValue == null) {
                return false;
            }
            field.set(parent, fieldValue);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            Type[] parameters = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            POJODeserializer.unpackMap((Map)field.get(parent), parameters[0], parameters[1], elem, marshaller);
            return true;
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            Type elementType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            POJODeserializer.unpackCollection((Collection)field.get(parent), elementType, elem, marshaller);
            return true;
        }
        return false;
    }

    private static boolean isCollections(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz);
    }

    public static void unpackMap(Map<Object, Object> map, Type keyType, Type valueType, JsonElement elem, Marshaller marshaller) throws DeserializationException {
        if (!(elem instanceof JsonObject)) {
            throw new DeserializationException("Cannot deserialize a " + elem.getClass().getSimpleName() + " into a Map - expected a JsonObject!");
        }
        Class<?> keyClass = TypeMagic.classForType(keyType);
        Class<?> valueClass = TypeMagic.classForType(valueType);
        JsonObject object = (JsonObject)elem;
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            try {
                Object k = marshaller.marshall(keyClass, (JsonElement)new JsonPrimitive(entry.getKey()));
                Object v = marshaller.marshall(valueClass, entry.getValue());
                if (k == null || v == null) continue;
                map.put(k, v);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void unpackCollection(Collection<Object> collection, Type elementType, JsonElement elem, Marshaller marshaller) throws DeserializationException {
        if (!(elem instanceof JsonArray)) {
            throw new DeserializationException("Cannot deserialize a " + elem.getClass().getSimpleName() + " into a Set - expected a JsonArray!");
        }
        JsonArray array = (JsonArray)elem;
        for (JsonElement arrayElem : array) {
            Object o = marshaller.marshall(elementType, arrayElem);
            if (o == null) continue;
            collection.add(o);
        }
    }
}

