/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import com.google.gson.Gson;
import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.config.ConfigData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHelper {
    private static final Path configPath = FabricLoader.getInstance().getConfigDir();
    private static final File configFile = new File(configPath + File.separator + "cobblegen.json5");
    private static final Jankson jankson = Jankson.builder().build();
    private static final Gson gson = new Gson();
    public static ConfigData CONFIG;

    public static void loadAndSaveDefault() {
        ConfigHelper.loadOrDefault();
        if (!configFile.exists()) {
            ConfigHelper.save();
        }
    }

    public static void loadOrDefault() {
        try {
            ConfigHelper.load();
            CobbleGen.LOGGER.info("Config file successfully loaded");
        }
        catch (Exception e) {
            CobbleGen.LOGGER.error("There was an error while (re)loading the config file!", (Throwable)e);
            CONFIG = new ConfigData();
            CobbleGen.LOGGER.warn("Falling back to default config...");
        }
    }

    @Deprecated
    @Nullable
    private static JsonElement filter(JsonElement json) {
        JsonObject result = null;
        if (json instanceof JsonObject) {
            JsonObject finalResult = (JsonObject)json;
            finalResult.keySet().forEach(key -> {
                JsonElement element = finalResult.get(key);
                if (!(element instanceof JsonNull) && element != null) {
                    ConfigHelper.filter(element);
                } else {
                    finalResult.remove(key);
                }
            });
            result = finalResult;
        } else if (json instanceof JsonArray) {
            JsonArray finalResult = (JsonArray)json;
            finalResult.forEach(element -> {
                if (element instanceof JsonObject) {
                    ConfigHelper.filter(element);
                }
            });
            result = finalResult;
        }
        return result;
    }

    public static void load() throws SyntaxError, IOException {
        try {
            CobbleGen.LOGGER.info("Trying to (re)load config file...");
            JsonObject json = jankson.load(configFile);
            CONFIG = (ConfigData)gson.fromJson(json.toJson(JsonGrammar.COMPACT), ConfigData.class);
        }
        catch (Exception e) {
            CobbleGen.LOGGER.error("There was an error while (re)loading the config file!", (Throwable)e);
            throw e;
        }
    }

    public static void save() {
        try {
            CobbleGen.LOGGER.info("Trying to create config file...");
            FileWriter fw = new FileWriter(configFile);
            JsonElement jsonElement = Jankson.builder().build().toJson((Object)CONFIG);
            JsonElement filteredElement = ConfigHelper.filter(jsonElement);
            fw.write((filteredElement != null ? filteredElement : jsonElement).toJson(JsonGrammar.JSON5));
            fw.close();
        }
        catch (IOException e) {
            CobbleGen.LOGGER.error("There was an error while creating the config file!", (Throwable)e);
        }
    }
}

