/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.polaroidcamera;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.hyper_pigeon.image2map.Image2Map;
import net.hyper_pigeon.image2map.renderer.MapRenderer;
import net.hyper_pigeon.polaroidcamera.items.CameraItem;
import net.hyper_pigeon.polaroidcamera.networking.PolaroidCameraNetworkingConstants;
import net.hyper_pigeon.polaroidcamera.persistent_state.ImagePersistentState;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class PolaroidCamera
implements ModInitializer {
    public static final CameraItem CAMERA_ITEM = new CameraItem(new class_1792.class_1793().method_7889(1).method_7892(class_1761.field_7932));

    public void onInitialize() {
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("polaroidcamera", "camera"), (Object)((Object)CAMERA_ITEM));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PolaroidCameraNetworkingConstants.SEND_IMAGE_BYTES, (server, player, handler, buf, responseSender) -> {
            String identifier = buf.method_19772();
            byte[] bytes = buf.method_10795();
            ImagePersistentState imagePersistentState = ImagePersistentState.get(player.method_14220());
            server.execute(() -> {
                if (!imagePersistentState.containsID(identifier)) {
                    imagePersistentState.addByteArray(identifier, bytes);
                } else {
                    imagePersistentState.appendByteArray(identifier, bytes);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PolaroidCameraNetworkingConstants.SEND_SCREENSHOT_IMAGE, (server, player, handler, buf, responseSender) -> {
            UUID imageId = buf.method_10790();
            int width = (int)buf.readDouble();
            int height = (int)buf.readFloat();
            String identifier = buf.method_10800(Short.MAX_VALUE);
            server.execute(() -> {
                if (player.method_31548().method_7379(new class_1799((class_1935)class_1802.field_8895)) || player.method_7337()) {
                    try {
                        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(ImagePersistentState.get(player.method_14220()).getByteArray(identifier)));
                        bufferedImage = this.crop(bufferedImage, bufferedImage.getHeight(), bufferedImage.getHeight());
                        class_1799 mapItemStack = MapRenderer.render(bufferedImage, Image2Map.DitherMode.FLOYD, (class_3218)player.method_5770(), player.method_23317(), player.method_23321(), (class_1657)player);
                        class_1542 itemEntity = new class_1542(player.field_6002, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, mapItemStack);
                        player.field_6002.method_8649((class_1297)itemEntity);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (!player.method_7337()) {
                        int slot = player.method_31548().method_7395(new class_1799((class_1935)class_1802.field_8895));
                        player.method_31548().method_5438(slot).method_7934(1);
                    }
                }
                ImagePersistentState.get(player.method_14220()).removeByteArray(identifier);
            });
        });
    }

    public BufferedImage crop(BufferedImage bufferedImage, int targetWidth, int targetHeight) throws IOException {
        int height = bufferedImage.getHeight();
        int width = bufferedImage.getWidth();
        int xc = (width - targetWidth) / 2;
        int yc = (height - targetHeight) / 2;
        BufferedImage croppedImage = bufferedImage.getSubimage(xc, yc, targetWidth, targetHeight);
        return croppedImage;
    }
}

