/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.blockEntity;

import cc.tweaked_programs.cccbridge.BlockRegister;
import cc.tweaked_programs.cccbridge.CCCSoundEvents;
import cc.tweaked_programs.cccbridge.peripherals.ScrollerBlockPeripheral;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollerBlockEntity
extends SmartTileEntity
implements IPeripheralTile {
    private ScrollerBlockPeripheral peripheral;
    private boolean locked = false;
    private boolean updateLock = false;
    private boolean playTickSound = false;

    public ScrollerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockRegister.getBlockEntityType("scroller_block"), pos, state);
    }

    public IPeripheral getPeripheral(@NotNull class_2350 side) {
        if (side == ((class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525)).method_10153()) {
            if (this.peripheral == null) {
                this.peripheral = new ScrollerBlockPeripheral(this, this.method_10997());
            }
            return this.peripheral;
        }
        return null;
    }

    public void setLock(boolean state) {
        this.locked = state;
        this.updateLock = true;
    }

    public void playTickSound() {
        this.playTickSound = true;
    }

    @Nullable
    public ScrollValueBehaviour getBehaviour() {
        TileEntityBehaviour behaviour = this.getBehaviour(ScrollValueBehaviour.TYPE);
        if (behaviour instanceof ScrollValueBehaviour) {
            ScrollValueBehaviour scrollValueBehaviour = (ScrollValueBehaviour)behaviour;
            return scrollValueBehaviour;
        }
        return null;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, class_2586 be) {
        if (!(be instanceof ScrollerBlockEntity)) {
            return;
        }
        ScrollerBlockEntity scroller = (ScrollerBlockEntity)be;
        if (scroller.updateLock && (Boolean)state.method_11654((class_2769)class_2741.field_12502) != scroller.locked) {
            world.method_8396(null, blockPos, scroller.locked ? CCCSoundEvents.CAGE_LOCK : CCCSoundEvents.CAGE_UNLOCK, class_3419.field_15245, 1.0f, 1.5f);
            world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12502, (Comparable)Boolean.valueOf(scroller.locked)));
            scroller.updateLock = false;
        }
        if (scroller.playTickSound) {
            world.method_8396(null, blockPos, AllSoundEvents.SCROLL_VALUE.getMainEvent(), class_3419.field_15245, 0.25f, 1.5f);
            scroller.playTickSound = false;
        }
        scroller.tick();
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        ScrollValueBehaviour scroller = new ScrollValueBehaviour((class_2561)this.method_11010().method_26204().method_9518(), (SmartTileEntity)this, (ValueBoxTransform)new ControllerValueBoxTransform()).between(-150, 150).moveText(new class_243(9.0, 0.0, 10.0)).withUnit(i -> new class_2588("cccbridge.general.unit.scroller")).withCallback(i -> {
            if (this.peripheral != null) {
                this.peripheral.newValue((int)i);
            }
        }).interactiveWhen(playerEntity -> (Boolean)playerEntity.method_37908().method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12502) == false).withStepFunction(context -> context.shift ? 1 : 10).withFormatter(i -> {
            StringBuilder number = new StringBuilder(String.valueOf(i));
            if (i <= -10 || i >= 10) {
                number.insert(number.length() - 1, '.');
            } else {
                number.insert(i >= 0 ? 0 : 1, "0.");
            }
            return number.toString();
        });
        scroller.value = 0;
        behaviours.add((TileEntityBehaviour)scroller);
    }

    private static class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)0.0);
        }

        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            return state.method_11654((class_2769)class_2741.field_12525) == direction;
        }

        protected float getScale() {
            return 0.5f;
        }
    }
}

