/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import cc.tweaked_programs.cccbridge.blockEntity.TargetBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetBlockPeripheral
implements IPeripheral {
    private final TargetBlockEntity target_block_entity;
    private final Terminal term = new Terminal(32, 24);

    public TargetBlockPeripheral(TargetBlockEntity target_block_entity) {
        this.target_block_entity = target_block_entity;
    }

    public void replaceLine(int y, String line) {
        if (y < 0 || y >= this.term.getHeight()) {
            return;
        }
        this.term.setCursorPos(0, y);
        this.term.clearLine();
        this.term.write(line);
    }

    public int getWidth() {
        return this.term.getWidth();
    }

    @LuaFunction
    public final void setWidth(int width) throws LuaException {
        if (width < 1 || width > 164) {
            throw new LuaException("Expected number in range 1-164");
        }
        this.term.resize(width, 16);
    }

    public int getHeight() {
        return this.term.getHeight();
    }

    @LuaFunction
    public final void clear() {
        this.term.clear();
    }

    @LuaFunction
    public final void clearLine(int y) {
        if (y < 1 || y > this.term.getHeight()) {
            return;
        }
        this.term.setCursorPos(0, y - 1);
        this.term.clearLine();
    }

    @LuaFunction
    public final String getLine(int y) throws LuaException {
        if (y < 1 || y > this.term.getHeight()) {
            throw new LuaException("Expected number in range 1-" + this.term.getHeight());
        }
        TextBuffer line = this.term.getLine(y - 1);
        return line.toString();
    }

    @LuaFunction
    public final Object[] getSize() {
        return new Object[]{this.term.getWidth(), this.term.getHeight()};
    }

    @NotNull
    public String getType() {
        return "create_target";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof TargetBlockPeripheral)) return false;
        TargetBlockPeripheral target = (TargetBlockPeripheral)other;
        if (target.target_block_entity != this.target_block_entity) return false;
        return true;
    }
}

