/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.TrainEditPacket;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.foundation.networking.AllPackets;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Objects;
import java.util.UUID;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrainPeripheral
implements IPeripheral {
    private static Schedule schedule;
    private final class_1937 level;
    private final StationTileEntity station;

    public TrainPeripheral(@NotNull class_2338 pos, class_1937 level) {
        this.level = level;
        this.station = (StationTileEntity)level.method_8321(pos);
    }

    @NotNull
    public String getType() {
        return "train_station";
    }

    @LuaFunction
    public final MethodResult assemble() {
        if (this.station.getStation().getPresentTrain() != null) {
            return MethodResult.of((Object[])new Object[]{false, "There is a assembled Train"});
        }
        if (this.station.tryEnterAssemblyMode()) {
            this.station.assemble(UUID.fromString("069a79f4-44e9-4726-a5be-fca90e38aaf5"));
            this.station.tick();
            if (schedule == null) {
                return MethodResult.of((Object[])new Object[]{false, "No Schedule saved"});
            }
            this.station.getStation().getPresentTrain().runtime.setSchedule(schedule, true);
            schedule = null;
            return MethodResult.of((Object[])new Object[]{true, "Train assembled"});
        }
        return MethodResult.of((Object[])new Object[]{false, "Can't assemble Train"});
    }

    @LuaFunction
    public final MethodResult disassemble() {
        if (this.station.getStation().getPresentTrain() == null) {
            return MethodResult.of((Object[])new Object[]{false, "there is no Train"});
        }
        if (this.station.getStation().getPresentTrain().canDisassemble()) {
            class_2350 direction = this.station.getAssemblyDirection();
            class_2338 position = this.station.edgePoint.getGlobalPosition().method_10084();
            schedule = this.station.getStation().getPresentTrain().runtime.getSchedule();
            class_3222 player = new class_3222(this.level.method_8503(), this.level.method_8503().method_30002(), new GameProfile(UUID.fromString("069a79f4-44e9-4726-a5be-fca90e38aaf5"), "Notch"));
            this.station.getStation().getPresentTrain().disassemble(player, direction, position);
            return MethodResult.of((Object[])new Object[]{true, "Train disassembled"});
        }
        return MethodResult.of((Object[])new Object[]{false, "Can't disassemble Train"});
    }

    @LuaFunction
    public String getStationName() {
        return this.station.getStation().name;
    }

    @LuaFunction
    public String getTrainName() {
        return Objects.requireNonNull(this.station.getStation().getPresentTrain()).name.getString();
    }

    @LuaFunction
    public final boolean setStationName(@NotNull String name) {
        GlobalStation station2 = this.station.getStation();
        GraphLocation graphLocation = this.station.edgePoint.determineGraphLocation();
        if (station2 != null && graphLocation != null) {
            station2.name = name;
            Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station2);
            Create.RAILWAYS.markTracksDirty();
            this.station.notifyUpdate();
            return true;
        }
        return false;
    }

    @LuaFunction
    public final MethodResult setTrainName(@NotNull String name) {
        if (this.station.getStation().getPresentTrain() == null) {
            return MethodResult.of((Object[])new Object[]{false, "There is no train to set the name of"});
        }
        Train train = this.station.getStation().getPresentTrain();
        Train Train2 = (Train)Create.RAILWAYS.sided((class_1936)this.level).trains.get(train.id);
        if (Train2 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Train not found"});
        }
        if (!name.isBlank()) {
            Train2.name = class_2561.method_30163((String)name);
            this.station.tick();
            AllPackets.channel.sendToClientsInServer((S2CPacket)new TrainEditPacket.TrainEditReturnPacket(train.id, name, Train2.icon.getId()), this.level.method_8503());
            return MethodResult.of((Object[])new Object[]{true, "Train name set to " + name});
        }
        return MethodResult.of((Object[])new Object[]{false, "Train name cannot be blank"});
    }

    @LuaFunction
    public int getBogeys() {
        if (this.station.getStation().getPresentTrain() == null) {
            return 0;
        }
        return this.station.getStation().getPresentTrain().carriages.size();
    }

    @LuaFunction
    public boolean getPresentTrain() {
        return this.station.getStation().getPresentTrain() != null;
    }

    @LuaFunction
    public void clearSchedule() {
        schedule = null;
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return this == iPeripheral;
    }
}

