/*
 * Decompiled with CFR 0.152.
 */
package com.limitedchunks.event;

import com.limitedchunks.LimitedChunksMod;
import com.limitedchunks.Utils.IChunkTicketManagerAccessor;
import com.limitedchunks.Utils.ITicketManagerGetter;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_4706;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class EventHandler {
    static Map<class_5321<class_1937>, Long2ObjectOpenHashMap<UUID>> posToPlayerID = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<UUID>>();
    static Map<class_5321<class_1937>, HashMap<UUID, LongSet>> playerIDToPos = new HashMap<class_5321<class_1937>, HashMap<UUID, LongSet>>();
    static Map<class_5321<class_1937>, Queue<ChunkPosAndTime>> unloadQue = new HashMap<class_5321<class_1937>, Queue<ChunkPosAndTime>>();
    public static Set<String> excludedTickets = new HashSet<String>();

    private static Long2ObjectOpenHashMap<UUID> getPosToPlayerIDMap(class_5321<class_1937> worldID) {
        return posToPlayerID.computeIfAbsent(worldID, k -> new Long2ObjectOpenHashMap());
    }

    private static HashMap<UUID, LongSet> getPlayerIDToPosMap(class_5321<class_1937> worldID) {
        return playerIDToPos.computeIfAbsent(worldID, k -> new HashMap());
    }

    public static void onWorldTick(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            Queue<ChunkPosAndTime> queue = unloadQue.get(world.method_27983());
            if (queue == null || queue.isEmpty()) {
                return;
            }
            ChunkPosAndTime current = queue.peek();
            if (current == null || current.time >= world.method_8503().method_3826()) continue;
            queue.poll();
            EventHandler.checkLoadedAndClear(current.pos, world);
        }
    }

    private static void checkLoadedAndClear(long pos, class_3218 world) {
        class_3222 player;
        Long2ObjectOpenHashMap<UUID> worldPositionsLoaded = EventHandler.getPosToPlayerIDMap((class_5321<class_1937>)world.method_27983());
        if (!worldPositionsLoaded.containsKey(pos)) {
            return;
        }
        UUID ownerUUID = (UUID)worldPositionsLoaded.get(pos);
        if (ownerUUID != null && (player = world.method_8503().method_3760().method_14602(ownerUUID)) != null) {
            return;
        }
        class_4706 ticketsE = (class_4706)((IChunkTicketManagerAccessor)((ITicketManagerGetter)world.method_14178()).getTicketManager()).getTicketsByPosition().get(pos);
        if (ticketsE == null) {
            return;
        }
        ArrayList<class_3228> ticketsToRemove = new ArrayList<class_3228>();
        for (class_3228 ticket : ticketsE) {
            if (ticket == null) continue;
            if (!excludedTickets.contains(ticket.method_14281().toString())) {
                if (LimitedChunksMod.config.getCommonConfig().debugLog) {
                    LimitedChunksMod.LOGGER.info("Unloading ticket:" + ticket.method_14281().toString() + " at chunkpos:" + new class_1923(pos));
                }
                ticketsToRemove.add(ticket);
                continue;
            }
            if (ticket.method_14281() != class_3230.field_14033) continue;
            class_1923 chunkPos = new class_1923(pos);
            class_1657 closeset = world.method_8604((double)(chunkPos.field_9181 << 4), 0.0, (double)(chunkPos.field_9180 << 4), -1.0, null);
            if (closeset == null) continue;
            worldPositionsLoaded.put(pos, (Object)closeset.method_5667());
            return;
        }
        for (class_3228 ticket : ticketsToRemove) {
            ((IChunkTicketManagerAccessor)((ITicketManagerGetter)world.method_14178()).getTicketManager()).removeTicketAccessor(pos, ticket);
        }
    }

    public static void initDefaultExcludes() {
        excludedTickets = new HashSet<String>();
        excludedTickets.add(class_3230.field_19347.toString());
        excludedTickets.add(class_3230.field_14033.toString());
        excludedTickets.add(class_3230.field_14030.toString());
        excludedTickets.add(class_3230.field_14032.toString());
        excludedTickets.add(class_3230.field_19280.toString());
    }

    public static void onChunkLoad(class_3218 world, class_2818 worldChunk) {
        class_1657 closeset = world.method_8604((double)(worldChunk.method_12004().field_9181 << 4), 0.0, (double)(worldChunk.method_12004().field_9180 << 4), -1.0, null);
        long pos = worldChunk.method_12004().method_8324();
        if (closeset != null) {
            EventHandler.getPlayerIDToPosMap((class_5321<class_1937>)world.method_27983()).computeIfAbsent(closeset.method_5667(), k -> new LongOpenHashSet()).add(pos);
            EventHandler.getPosToPlayerIDMap((class_5321<class_1937>)world.method_27983()).put(pos, (Object)closeset.method_5667());
        } else {
            EventHandler.getPosToPlayerIDMap((class_5321<class_1937>)world.method_27983()).put(pos, null);
            Queue quedChunks = unloadQue.computeIfAbsent((class_5321<class_1937>)world.method_27983(), s -> new PriorityQueue());
            quedChunks.add(new ChunkPosAndTime(pos, world.method_8503().method_3826() + (long)(LimitedChunksMod.config.getCommonConfig().chunkunloadnoplayer * 1000 * 60)));
        }
    }

    public static void onChunkUnLoad(class_3218 world, class_2818 worldChunk) {
        Set positions;
        long pos = worldChunk.method_12004().method_8324();
        UUID playerID = (UUID)EventHandler.getPosToPlayerIDMap((class_5321<class_1937>)world.method_27983()).remove(pos);
        if (playerID != null && (positions = (Set)EventHandler.getPlayerIDToPosMap((class_5321<class_1937>)world.method_27983()).get(playerID)) != null) {
            positions.remove(pos);
        }
    }

    public static void onPlayerLeave(class_3222 player) {
        class_3218 world = player.method_14220();
        for (Map.Entry<class_5321<class_1937>, HashMap<UUID, LongSet>> dimEntry : playerIDToPos.entrySet()) {
            LongSet chunksFromPlayer;
            HashMap<UUID, LongSet> playerToPosMap = dimEntry.getValue();
            if (playerToPosMap == null || (chunksFromPlayer = playerToPosMap.remove(player.method_5667())) == null) continue;
            Queue quedChunks = unloadQue.computeIfAbsent(dimEntry.getKey(), s -> new PriorityQueue());
            LongIterator longIterator = chunksFromPlayer.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                quedChunks.add(new ChunkPosAndTime(pos, world.method_8503().method_3826() + (long)LimitedChunksMod.config.getCommonConfig().chunkunloadnoplayer * 1000L * 60L));
            }
        }
    }

    public static void onServerAboutToStart(MinecraftServer server) {
        posToPlayerID = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<UUID>>();
        playerIDToPos = new HashMap<class_5321<class_1937>, HashMap<UUID, LongSet>>();
        unloadQue = new HashMap<class_5321<class_1937>, Queue<ChunkPosAndTime>>();
    }

    private static class ChunkPosAndTime
    implements Comparable<ChunkPosAndTime> {
        final long pos;
        final long time;

        ChunkPosAndTime(long pos, long time) {
            this.pos = pos;
            this.time = time;
        }

        @Override
        public int compareTo(ChunkPosAndTime o) {
            return (int)(this.time - o.time);
        }
    }
}

