/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.ServerboundVariableCommandSuggestionsPacketHandler;
import de.keksuccino.fancymenu.networking.packets.command.commands.variable.VariableCommandSuggestionsPacketMessage;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.command.ClientExecutor;
import de.keksuccino.konkrete.command.CommandUtils;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.events.client.ClientTickEvent;
import de.keksuccino.konkrete.localization.Locals;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;

public class VariableCommand {
    protected static class_437 lastScreen = null;
    protected static boolean initialized = false;

    public static void register(CommandDispatcher<class_2168> d) {
        if (!initialized) {
            Konkrete.getEventHandler().registerEventsFrom((Object)new VariableCommand());
            initialized = true;
        }
        d.register((LiteralArgumentBuilder)class_2170.method_9247((String)"fmvariable").then(class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])new String[]{"get", "set"})).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"variable_name", (ArgumentType)StringArgumentType.string()).executes(stack -> VariableCommand.getVariable((class_2168)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions())).then(class_2170.method_9244((String)"set_to_value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"action").equalsIgnoreCase("set")) {
                return CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])new String[]{"<set_to_value>"});
            }
            return CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])new String[0]);
        }).then(class_2170.method_9244((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).executes(stack -> VariableCommand.setVariable((class_2168)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"action"), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions() {
        List<String> l = VariableHandler.getVariableNames();
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(class_2168 stack, String getOrSet, String variableName) {
        ClientExecutor.execute(() -> {
            try {
                if (getOrSet.equalsIgnoreCase("get")) {
                    String s = VariableHandler.getVariable(variableName);
                    if (s != null) {
                        stack.method_9226((class_2561)new class_2585(Locals.localize((String)"fancymenu.commands.variable.get.success", (String[])new String[]{s})), false);
                    } else {
                        stack.method_9213((class_2561)new class_2585(Locals.localize((String)"fancymenu.commands.variable.not_found", (String[])new String[0])));
                    }
                }
            }
            catch (Exception e) {
                stack.method_9213((class_2561)new class_2585("Error while executing command!"));
                e.printStackTrace();
            }
        });
        return 1;
    }

    private static int setVariable(class_2168 stack, String getOrSet, String variableName, String setToValue, boolean sendFeedback) {
        ClientExecutor.execute(() -> {
            try {
                if (getOrSet.equalsIgnoreCase("set")) {
                    VariableHandler.setVariable(variableName, setToValue);
                    if (sendFeedback) {
                        stack.method_9226((class_2561)new class_2585(Locals.localize((String)"fancymenu.commands.variable.set.success", (String[])new String[]{setToValue})), false);
                    }
                }
            }
            catch (Exception e) {
                stack.method_9213((class_2561)new class_2585("Error while executing command!"));
                e.printStackTrace();
            }
        });
        return 1;
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre e) {
        class_437 s = class_310.method_1551().field_1755;
        if (s instanceof class_408 && (lastScreen == null || lastScreen != s)) {
            VariableCommandSuggestionsPacketMessage msg = new VariableCommandSuggestionsPacketMessage();
            msg.direction = "server";
            msg.variableNameSuggestions.addAll(Arrays.asList(VariableCommand.getVariableNameSuggestions()));
            ClientPlayNetworking.send((class_2960)ServerboundVariableCommandSuggestionsPacketHandler.PACKET_ID, (class_2540)ServerboundVariableCommandSuggestionsPacketHandler.writeToByteBuf(msg));
        }
        lastScreen = s;
    }
}

