/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class ResourcePackAnimationRenderer
implements IAnimationRenderer {
    protected String resourceNamespace;
    protected List<String> frameNames;
    protected int fps;
    protected boolean loop;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    public List<class_2960> resources = new ArrayList<class_2960>();
    protected boolean stretch = false;
    protected boolean hide = false;
    protected volatile boolean done = false;
    private int frame = 0;
    private long prevTime = 0L;
    protected float opacity = 1.0f;
    private boolean ready = false;
    protected boolean sizeSet = false;

    public ResourcePackAnimationRenderer(@Nullable String resourceNamespace, List<String> frameNames, int fps, boolean loop, int posX, int posY, int width, int height) {
        this.fps = fps;
        this.loop = loop;
        this.x = posX;
        this.y = posY;
        this.width = width;
        this.height = height;
        this.resourceNamespace = resourceNamespace;
        this.frameNames = frameNames;
        this.loadAnimationFrames();
    }

    private void loadAnimationFrames() {
        try {
            for (String s : this.frameNames) {
                class_2960 r = this.resourceNamespace == null ? new class_2960(s) : new class_2960(this.resourceNamespace, s);
                this.resources.add(r);
            }
            this.ready = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(class_4587 matrix) {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        if (this.fps < 0) {
            this.fps = -1;
        }
        if (this.frame > this.resources.size() - 1) {
            if (this.loop) {
                this.resetAnimation();
            } else {
                this.done = true;
                if (!this.hide) {
                    this.frame = this.resources.size() - 1;
                } else {
                    return;
                }
            }
        }
        this.renderFrame(matrix);
        long time = System.currentTimeMillis();
        if (this.fps == -1) {
            this.updateFrame(time);
        } else if (this.prevTime + (long)(1000 / this.fps) <= time) {
            this.updateFrame(time);
        }
    }

    protected void renderFrame(class_4587 matrix) {
        int h = this.height;
        int w = this.width;
        int x2 = this.x;
        int y2 = this.y;
        if (this.stretch) {
            h = class_310.method_1551().field_1755.field_22790;
            w = class_310.method_1551().field_1755.field_22789;
            x2 = 0;
            y2 = 0;
        }
        RenderUtils.bindTexture((class_2960)this.resources.get(this.frame));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
        class_332.method_25290((class_4587)matrix, (int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        RenderSystem.disableBlend();
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    private void updateFrame(long time) {
        ++this.frame;
        this.prevTime = time;
    }

    public void resetAnimation() {
        this.frame = 0;
        this.prevTime = 0L;
        this.done = false;
    }

    public void setStretchImageToScreensize(boolean b) {
        this.stretch = b;
    }

    public void setHideAfterLastFrame(boolean b) {
        this.hide = b;
    }

    public boolean isFinished() {
        return this.done;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int currentFrame() {
        return this.frame;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setPosX(int x) {
        this.x = x;
    }

    public void setPosY(int y) {
        this.y = y;
    }

    public int animationFrames() {
        return this.resources.size();
    }

    public List<class_2960> getAnimationFrames() {
        return this.resources;
    }

    public String getPath() {
        return this.resourceNamespace;
    }

    public void setFPS(int fps) {
        this.fps = fps;
    }

    public int getFPS() {
        return this.fps;
    }

    public void setLooped(boolean b) {
        this.loop = b;
    }

    public void prepareAnimation() {
    }

    public boolean isGettingLooped() {
        return this.loop;
    }

    public boolean isStretchedToStreensize() {
        return this.stretch;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public boolean setupAnimationSize() {
        if (this.sizeSet) {
            return true;
        }
        try {
            List<class_2960> l = this.getAnimationFrames();
            if (!l.isEmpty()) {
                InputStream in;
                class_2960 r = l.get(0);
                class_3298 res = class_310.method_1551().method_1478().method_14486(r);
                if (res != null && (in = res.method_14482()) != null) {
                    class_1011 i = class_1011.method_4309((InputStream)in);
                    this.width = i.method_4307();
                    this.height = i.method_4323();
                    System.out.println("[FANCYMENU] Successfully updated width and height for resource pack animation: " + this.resourceNamespace);
                    this.sizeSet = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("[FANCYMENU] ERROR: Failed to update width and height for resource pack animation: " + this.resourceNamespace);
        return false;
    }
}

