/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2;

import de.keksuccino.fancymenu.menu.placeholder.v1.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderRegistry;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, Long> logCooldown = new HashMap<String, Long>();

    @NotNull
    public static String replacePlaceholders(@NotNull String in) {
        if (in == null) {
            in = "";
        }
        PlaceholderParser.updateLogHandler();
        in = DynamicValueHelper.convertFromRaw(in);
        String ori = in = StringUtils.convertFormatCodes((String)in, (String)"&", (String)"\u00a7");
        String rep = null;
        while (rep == null || !rep.equals(ori)) {
            if (rep != null) {
                ori = rep;
            }
            if ((rep = PlaceholderParser.innerReplacePlaceholders(ori)) != null) continue;
        }
        if (rep != null) {
            return rep.replace("\\\"", "\"").replace("\\{", "{").replace("\\}", "}");
        }
        return in;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String innerReplacePlaceholders(String in) {
        try {
            String out = in;
            int skipToIndex = 0;
            int currentIndex = 0;
            char[] cArray = in.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                block12: {
                    String ps;
                    block13: {
                        String s;
                        if (n2 >= n) {
                            return out;
                        }
                        char c = cArray[n2];
                        if (currentIndex < skipToIndex || !(s = String.valueOf(c)).equals("{") || !in.substring(currentIndex).startsWith("{\"placeholder\":")) break block12;
                        int endIndex = PlaceholderParser.findEndIndex(in, currentIndex);
                        if (endIndex <= currentIndex) {
                            PlaceholderParser.logError("[FANCYMENU] Unable to replace placeholder! EndIndex <= CurrentIndex: " + in);
                            return null;
                        }
                        skipToIndex = endIndex;
                        ps = in.substring(currentIndex, endIndex);
                        String placeholderIdentifier = PlaceholderParser.getPlaceholderIdentifier(ps);
                        if (placeholderIdentifier == null) {
                            PlaceholderParser.logError("[FANCYMENU] Unable to parse placeholder identifier: " + in);
                            return null;
                        }
                        Placeholder p = PlaceholderRegistry.getPlaceholderForIdentifier(placeholderIdentifier);
                        if (p == null) break block13;
                        int valueStartIndex = PlaceholderParser.findValueStartIndex(ps);
                        if (valueStartIndex != -1) {
                            int valueEndIndex = PlaceholderParser.findEndIndex(ps, valueStartIndex + 10);
                            if (valueEndIndex <= valueStartIndex) {
                                PlaceholderParser.logError("[FANCYMENU] Unable to replace placeholder! ValueEndIndex <= ValueStartIndex: " + ps);
                                return null;
                            }
                            String valueString = ps.substring(valueStartIndex + 10 + 1, valueEndIndex - 1);
                            DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
                            dps.values = PlaceholderParser.getPlaceholderValues(p, valueString);
                            dps.placeholder = p.id;
                            dps.originalString = ps;
                            LinkedHashMap<String, String> finalValues = new LinkedHashMap<String, String>();
                            for (Map.Entry<String, String> m : dps.values.entrySet()) {
                                String inner = PlaceholderParser.innerReplacePlaceholders(m.getValue());
                                finalValues.put(m.getKey(), inner);
                            }
                            dps.values = finalValues;
                            String actualTextOfPs = p.getReplacementFor(dps);
                            if (actualTextOfPs != null) {
                                out = out.replace(dps.originalString, actualTextOfPs);
                            }
                            break block12;
                        } else {
                            DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
                            dps.placeholder = placeholderIdentifier;
                            dps.originalString = ps;
                            String actualTextOfPs = p.getReplacementFor(dps);
                            if (actualTextOfPs != null) {
                                out = out.replace(dps.originalString, actualTextOfPs);
                            }
                        }
                        break block12;
                    }
                    PlaceholderParser.logError("[FANCYMENU] Unknown placeholder: " + ps);
                }
                ++currentIndex;
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static String getPlaceholderIdentifier(String placeholderString) {
        if (placeholderString != null && placeholderString.startsWith("{\"placeholder\":\"")) {
            return placeholderString.split("[\"]")[3];
        }
        return null;
    }

    @NotNull
    private static Map<String, String> getPlaceholderValues(Placeholder placeholder, String valueString) {
        if (placeholder == null || valueString == null || placeholder.getValueNames() == null || placeholder.getValueNames().isEmpty()) {
            return new HashMap<String, String>();
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        try {
            int currentIndex = 0;
            int inValueDepth = 0;
            String currentValueName = null;
            int currentValueStartIndex = 0;
            for (char c : valueString.toCharArray()) {
                if (currentIndex >= currentValueStartIndex) {
                    String s = String.valueOf(c);
                    if (s.equals("\"")) {
                        if (currentValueName != null) {
                            if (inValueDepth == 0 && !valueString.substring(currentIndex - 1).startsWith("\\") && PlaceholderParser.isEndOfValueContent(placeholder, valueString, currentIndex)) {
                                String valueContent = valueString.substring(currentValueStartIndex, currentIndex);
                                m.put(currentValueName, valueContent);
                                currentValueName = null;
                                currentValueStartIndex = 0;
                            }
                        } else {
                            currentValueName = PlaceholderParser.getValueNameIfStartingWithValue(placeholder, valueString.substring(currentIndex));
                            if (currentValueName != null) {
                                currentValueStartIndex = currentIndex + currentValueName.length() + 4;
                                inValueDepth = 0;
                            }
                        }
                    }
                    if (s.equals("{") && currentValueName != null && !valueString.substring(currentIndex - 1).startsWith("\\")) {
                        ++inValueDepth;
                    }
                    if (s.equals("}") && currentValueName != null && !valueString.substring(currentIndex - 1).startsWith("\\") && inValueDepth > 0) {
                        --inValueDepth;
                    }
                }
                ++currentIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    private static boolean isEndOfValueContent(Placeholder placeholder, String valueString, int currentIndex) {
        String s3;
        String nextValue;
        if (valueString.length() == currentIndex + 1) {
            return true;
        }
        String s1 = valueString.substring(currentIndex - 2);
        if (s1.startsWith("\"}\"")) {
            return true;
        }
        String s2 = valueString.substring(currentIndex);
        return s2.startsWith("\",\"") && (nextValue = PlaceholderParser.getValueNameIfStartingWithValue(placeholder, s3 = valueString.substring(currentIndex + 2))) != null;
    }

    private static String getValueNameIfStartingWithValue(Placeholder placeholder, String s) {
        if (placeholder.getValueNames() == null) {
            return null;
        }
        for (String name : placeholder.getValueNames()) {
            if (!s.startsWith("\"" + name + "\":\"")) continue;
            return name;
        }
        return null;
    }

    private static int findValueStartIndex(String placeholderString) {
        int currentIndex = 1;
        for (char c : placeholderString.substring(1).toCharArray()) {
            if (String.valueOf(c).startsWith(",") && placeholderString.substring(currentIndex).startsWith(",\"values\":")) {
                return currentIndex;
            }
            ++currentIndex;
        }
        return -1;
    }

    private static int findEndIndex(String in, int startIndex) {
        if (in.substring(startIndex).startsWith("{") && (startIndex == 0 || !in.substring(startIndex - 1).startsWith("\\"))) {
            int currentIndex = startIndex + 1;
            int depth = 0;
            for (char c : in.substring(startIndex + 1).toCharArray()) {
                if (String.valueOf(c).equals("{") && !in.substring(currentIndex - 1).startsWith("\\")) {
                    ++depth;
                } else if (String.valueOf(c).equals("}") && !in.substring(currentIndex - 1).startsWith("\\")) {
                    if (depth <= 0) {
                        return currentIndex + 1;
                    }
                    --depth;
                }
                ++currentIndex;
            }
        }
        return -1;
    }

    private static void logError(String error) {
        if (!logCooldown.containsKey(error)) {
            LOGGER.error(error);
            logCooldown.put(error, System.currentTimeMillis());
        }
    }

    private static void updateLogHandler() {
        long now = System.currentTimeMillis();
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry<String, Long> m : logCooldown.entrySet()) {
            if (m.getValue() + 10000L > now) continue;
            remove.add(m.getKey());
        }
        for (String s : remove) {
            logCooldown.remove(s);
        }
    }
}

