/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfigData;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CowJarBlockEntity
extends MilkJarBlockEntity
implements IMutableNameable {
    private static final int UPDATE_INTERVAL = 20;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private class_2561 customName;
    private boolean compressedCow;

    public CowJarBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends MilkJarBlockEntity>)((class_2591)ModBlockEntities.cowJar.get()), pos, state);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"));
        }
        this.compressedCow = tag.method_10577("CompressedCow");
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10556("CompressedCow", this.compressedCow);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CowJarBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.milkTank.getAmount() < 32000) {
            CookingForBlockheadsConfigData config = CookingForBlockheadsConfig.getActive();
            int milkToAdd = config.cowJarMilkPerTick;
            if (this.compressedCow) {
                milkToAdd = (int)((double)milkToAdd * config.compressedCowJarMilkMultiplier);
            }
            this.milkTank.fill(Compat.getMilkFluid(), milkToAdd, false);
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean isCompressedCow() {
        return this.compressedCow;
    }

    public void setCompressedCow(boolean compressedCow) {
        this.compressedCow = compressedCow;
    }

    @Override
    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public class_2561 getDefaultName() {
        if (this.compressedCow) {
            return new class_2588("container.cookingforblockheads.cow_jar_compressed");
        }
        return new class_2588("container.cookingforblockheads.cow_jar");
    }
}

