/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.FabricEvents;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.data.AdvancementsProvider;
import slimeknights.tconstruct.common.data.loot.GlobalLootModifiersProvider;
import slimeknights.tconstruct.common.data.loot.TConstructLootTableProvider;
import slimeknights.tconstruct.common.data.tags.BiomeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockEntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockTagProvider;
import slimeknights.tconstruct.common.data.tags.EntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.FluidTagProvider;
import slimeknights.tconstruct.common.data.tags.ItemTagProvider;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.TinkerBookIDs;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.WorldEvents;

public class TConstruct
implements ModInitializer {
    public static final String MOD_ID = "tconstruct";
    public static final Logger LOG = LogManager.getLogger((String)"tconstruct");
    public static final Random RANDOM = new Random();
    public static TConstruct instance;

    public void onInitialize() {
        instance = this;
        Config.init();
        new TinkerCommons();
        new TinkerMaterials();
        new TinkerFluids();
        new TinkerGadgets();
        new TinkerWorld();
        new TinkerStructures();
        new TinkerTables();
        new TinkerModifiers();
        new TinkerToolParts();
        new TinkerTools();
        new TinkerSmeltery();
        TinkerModule.initRegisters();
        TinkerGadgets.commonSetup();
        TinkerWorld.init();
        TinkerTags.init();
        WorldEvents.init();
        TinkerNetwork.setup();
        TinkerBookIDs.registerCommandSuggestion();
        if (FabricLoader.getInstance().isModLoaded("immersiveengineering")) {
            // empty if block
        }
        TConstruct.commonSetup();
        FabricEvents.init();
    }

    static void commonSetup() {
        MaterialRegistry.init();
        ToolDefinitionLoader.init();
        StationSlotLayoutLoader.init();
    }

    public static void onInitializeDataGenerator(FabricDataGenerator datagenerator, ExistingFileHelper existingFileHelper) {
        BlockTagProvider blockTags = new BlockTagProvider(datagenerator);
        datagenerator.method_10314((class_2405)blockTags);
        datagenerator.method_10314((class_2405)new ItemTagProvider(datagenerator, blockTags));
        datagenerator.method_10314((class_2405)new FluidTagProvider(datagenerator));
        datagenerator.method_10314((class_2405)new EntityTypeTagProvider(datagenerator));
        datagenerator.method_10314((class_2405)new BlockEntityTypeTagProvider(datagenerator));
        datagenerator.method_10314((class_2405)new TConstructLootTableProvider(datagenerator));
        datagenerator.method_10314((class_2405)new AdvancementsProvider((class_2403)datagenerator));
        datagenerator.method_10314((class_2405)new BiomeTagProvider(datagenerator));
        datagenerator.method_10314((class_2405)new GlobalLootModifiersProvider((class_2403)datagenerator));
    }

    public static class_2960 getResource(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static <T> TinkerDataCapability.TinkerDataKey<T> createKey(String name) {
        return TinkerDataCapability.TinkerDataKey.of(TConstruct.getResource(name));
    }

    public static <T> TinkerDataCapability.ComputableDataKey<T> createKey(String name, Supplier<T> constructor) {
        return TinkerDataCapability.ComputableDataKey.of(TConstruct.getResource(name), constructor);
    }

    public static String resourceString(String res) {
        return String.format("%s:%s", MOD_ID, res);
    }

    public static String prefix(String name) {
        return String.format("%s.%s", MOD_ID, name.toLowerCase(Locale.US));
    }

    public static String makeTranslationKey(String base, String name) {
        return Util.makeTranslationKey(base, TConstruct.getResource(name));
    }

    public static class_5250 makeTranslation(String base, String name) {
        return new class_2588(TConstruct.makeTranslationKey(base, name));
    }

    public static class_5250 makeTranslation(String base, String name, Object ... arguments) {
        return new class_2588(TConstruct.makeTranslationKey(base, name), arguments);
    }

    public static void sealTinkersClass(Object self, String base, String solution) {
        String name = self.getClass().getName();
        if (!name.startsWith("slimeknights.tconstruct.")) {
            throw new IllegalStateException(base + " being extended from invalid package " + name + ". " + solution);
        }
    }
}

