/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerUpper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3499;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_6861;
import net.minecraftforge.common.data.ExistingFileHelper;

public class StructureUpdater
implements class_2405 {
    private final class_3264 packType;
    private final String basePath;
    private final String modid;
    private final class_2403 gen;
    private final class_6861 resources;

    public StructureUpdater(class_2403 gen, ExistingFileHelper helper, String modid, class_3264 packType, String basePath) {
        this.gen = gen;
        this.modid = modid;
        this.packType = packType;
        this.basePath = basePath;
        try {
            Field resourceManager = ExistingFileHelper.class.getDeclaredField(packType == class_3264.field_14190 ? "serverData" : "clientResources");
            resourceManager.setAccessible(true);
            this.resources = (class_6861)resourceManager.get(helper);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_10319(class_2408 cache) throws IOException {
        for (class_2960 loc : this.resources.method_14488(this.basePath, file -> file.endsWith(".nbt"))) {
            if (!loc.method_12836().equals(this.modid)) continue;
            this.process(loc, cache);
        }
    }

    private void process(class_2960 loc, class_2408 cache) throws IOException {
        class_2487 inputNBT = class_2507.method_10629((InputStream)this.resources.method_14486(loc).method_14482());
        class_2487 converted = StructureUpdater.updateNBT(inputNBT);
        if (!converted.equals((Object)inputNBT)) {
            Class<?> fixerClass = class_3551.method_15450().getClass();
            if (!fixerClass.equals(DataFixerUpper.class)) {
                throw new RuntimeException("Structures are not up to date, but unknown data fixer is in use: " + fixerClass.getName());
            }
            this.writeNBTTo(loc, converted, cache);
        }
    }

    private void writeNBTTo(class_2960 loc, class_2487 data, class_2408 cache) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        class_2507.method_10634((class_2487)data, (OutputStream)bytearrayoutputstream);
        byte[] bytes = bytearrayoutputstream.toByteArray();
        String hashString = field_11280.hashBytes(bytes).toString();
        Path outputPath = this.gen.method_10313().resolve(this.packType.method_14413() + "/" + loc.method_12836() + "/" + loc.method_12832());
        if (!Objects.equals(cache.method_10323(outputPath), hashString) || !Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (OutputStream outputstream = Files.newOutputStream(outputPath, new OpenOption[0]);){
                outputstream.write(bytes);
            }
        }
        cache.method_10325(outputPath, hashString);
    }

    private static class_2487 updateNBT(class_2487 nbt) {
        class_2487 updatedNBT = class_2512.method_10688((DataFixer)class_3551.method_15450(), (class_4284)class_4284.field_19217, (class_2487)nbt, (int)nbt.method_10550("DataVersion"));
        class_3499 template = new class_3499();
        template.method_15183(updatedNBT);
        return template.method_15175(new class_2487());
    }

    public String method_10321() {
        return "Update structure files in " + this.basePath;
    }
}

