/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_58;
import net.minecraft.class_60;
import org.slf4j.Logger;
import slimeknights.tconstruct.common.data.loot.AdvancementLootTableProvider;
import slimeknights.tconstruct.common.data.loot.BlockLootTableProvider;
import slimeknights.tconstruct.common.data.loot.EntityLootTableProvider;

public class TConstructLootTableProvider
extends class_2438 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private class_2438 x;
    private final List<Pair<Supplier<Consumer<BiConsumer<class_2960, class_52.class_53>>>, class_176>> lootTables = ImmutableList.of((Object)Pair.of(BlockLootTableProvider::new, (Object)class_173.field_1172), (Object)Pair.of(AdvancementLootTableProvider::new, (Object)class_173.field_1174), (Object)Pair.of(EntityLootTableProvider::new, (Object)class_173.field_1173));
    private final FabricDataGenerator gen;

    public TConstructLootTableProvider(FabricDataGenerator gen) {
        super((class_2403)gen);
        this.gen = gen;
    }

    protected void validate(Map<class_2960, class_52> map, class_58 validationtracker) {
        map.forEach((loc, table) -> class_60.method_369((class_58)validationtracker, (class_2960)loc, (class_52)table));
        map.keySet().removeIf(loc -> !loc.method_12836().equals("tconstruct"));
    }

    public void method_10319(class_2408 pCache) {
        Path path = this.gen.method_10313();
        HashMap map = Maps.newHashMap();
        this.lootTables.forEach(p_124458_ -> ((Consumer)((Supplier)p_124458_.getFirst()).get()).accept((p_176077_, p_176078_) -> {
            if (map.put(p_176077_, p_176078_.method_334((class_176)p_124458_.getSecond()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + p_176077_);
            }
        }));
        class_58 validationcontext = new class_58(class_173.field_1177, p_124465_ -> null, map::get);
        this.validate(map, validationcontext);
        Multimap multimap = validationcontext.method_361();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((p_124451_, p_124452_) -> {
            Path path1 = TConstructLootTableProvider.createPath(path, p_124451_);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)pCache, (JsonElement)class_60.method_372((class_52)p_124452_), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save loot table {}", (Object)path1, (Object)ioexception);
            }
        });
    }

    private static Path createPath(Path path, class_2960 resourceLocation) {
        String var10001 = resourceLocation.method_12836();
        return path.resolve("data/" + var10001 + "/loot_tables/" + resourceLocation.method_12832() + ".json");
    }

    public String method_10321() {
        return "TConstruct LootTables";
    }
}

