/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.tags;

import java.util.Objects;
import java.util.function.Supplier;
import me.alphamode.forgetags.Tags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1834;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassPaneBlock;
import slimeknights.tconstruct.shared.block.PlatformBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockTagProvider
extends FabricTagProvider.BlockTagProvider {
    public BlockTagProvider(FabricDataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void generateTags() {
        this.addCommon();
        this.addTools();
        this.addWorld();
        this.addSmeltery();
        this.addFluids();
        this.addHarvest();
    }

    private void addCommon() {
        this.addMetalTags(TinkerMaterials.cobalt, true);
        this.addMetalTags(TinkerMaterials.slimesteel, false);
        this.addMetalTags(TinkerMaterials.amethystBronze, false);
        this.addMetalTags(TinkerMaterials.roseGold, false);
        this.addMetalTags(TinkerMaterials.pigIron, false);
        this.addMetalTags(TinkerMaterials.queensSlime, true);
        this.addMetalTags(TinkerMaterials.manyullyn, true);
        this.addMetalTags(TinkerMaterials.hepatizon, true);
        this.addMetalTags(TinkerMaterials.soulsteel, true);
        this.addMetalTags(TinkerMaterials.knightslime, false);
        FabricTagProvider.FabricTagBuilder silicaPanes = this.tag(TinkerTags.Blocks.GLASS_PANES_SILICA);
        silicaPanes.method_26795((Object[])new class_2248[]{class_2246.field_10285, (class_2248)TinkerCommons.clearGlassPane.get(), class_2246.field_10070, class_2246.field_9982, class_2246.field_10163, class_2246.field_10355, class_2246.field_10077, class_2246.field_10419, class_2246.field_10193, class_2246.field_10129, class_2246.field_10305, class_2246.field_10469, class_2246.field_10496, class_2246.field_10565, class_2246.field_10152, class_2246.field_10118, class_2246.field_9991, class_2246.field_10578});
        this.tag((class_6862<class_2248>)Tags.Blocks.GLASS_COLORLESS).add((Object)TinkerCommons.clearGlass.get());
        this.tag((class_6862<class_2248>)Tags.Blocks.GLASS_PANES_COLORLESS).add((Object)TinkerCommons.clearGlassPane.get());
        this.addGlass(TinkerCommons.clearStainedGlass, "glass/", (class_2474.class_5124<class_2248>)this.tag((class_6862<class_2248>)Tags.Blocks.STAINED_GLASS));
        this.addGlass(TinkerCommons.clearStainedGlassPane, "glass_panes/", (class_2474.class_5124<class_2248>)this.tag((class_6862<class_2248>)Tags.Blocks.STAINED_GLASS_PANES));
        TinkerCommons.clearStainedGlassPane.forEach(arg_0 -> BlockTagProvider.lambda$addCommon$0((class_2474.class_5124)silicaPanes, arg_0));
        FabricTagProvider.FabricTagBuilder impermeable = this.tag((class_6862<class_2248>)class_3481.field_15490);
        impermeable.method_26795((Object[])new class_2248[]{(class_2248)TinkerCommons.clearGlass.get(), (class_2248)TinkerCommons.soulGlass.get(), (class_2248)TinkerSmeltery.searedGlass.get(), (class_2248)TinkerCommons.clearTintedGlass.get()});
        TinkerCommons.clearStainedGlass.values().forEach(arg_0 -> ((class_2474.class_5124)impermeable).method_26793(arg_0));
        this.tag((class_6862<class_2248>)class_3481.field_23063).add(new Object[]{TinkerCommons.soulGlass.get(), TinkerCommons.soulGlassPane.get()});
        this.tag((class_6862<class_2248>)class_3481.field_23119).add((Object)TinkerCommons.soulGlass.get());
        FabricTagProvider.FabricTagBuilder builder = this.tag(TinkerTags.Blocks.ANVIL_METAL).addTag(TinkerMaterials.slimesteel.getBlockTag()).addTag(TinkerMaterials.amethystBronze.getBlockTag()).addTag(TinkerMaterials.roseGold.getBlockTag()).addTag(TinkerMaterials.pigIron.getBlockTag()).addTag(TinkerMaterials.queensSlime.getBlockTag()).addTag(TinkerMaterials.manyullyn.getBlockTag()).addTag(TinkerMaterials.hepatizon.getBlockTag()).forceAddTag(Tags.Blocks.STORAGE_BLOCKS_NETHERITE);
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (compat.isOre()) continue;
            builder.method_35923(new class_2960("c", "storage_blocks/" + compat.getName()));
        }
        this.tag(TinkerTags.Blocks.PLANKLIKE).addTag(class_3481.field_15471).add(new Object[]{TinkerCommons.lavawood.get(), TinkerCommons.blazewood.get(), TinkerMaterials.nahuatl.get()});
        this.tag(TinkerTags.Blocks.PLATFORM_CONNECTIONS).add(new Object[]{class_2246.field_10363, class_2246.field_9983, class_2246.field_10576, TinkerCommons.goldBars.get(), class_2246.field_10348, class_2246.field_10099, class_2246.field_22093, class_2246.field_10301, class_2246.field_10091}).forceAddTag(Tags.Blocks.GLASS_PANES).forceAddTag(class_3481.field_15493).forceAddTag(Tags.Blocks.FENCES).forceAddTag(class_3481.field_15504).forceAddTag(class_3481.field_15492);
        FabricTagProvider.FabricTagBuilder copperPlatforms = this.tag(TinkerTags.Blocks.COPPER_PLATFORMS);
        TinkerCommons.copperPlatform.forEach(arg_0 -> BlockTagProvider.lambda$addCommon$1((class_2474.class_5124)copperPlatforms, arg_0));
        TinkerCommons.waxedCopperPlatform.forEach(arg_0 -> BlockTagProvider.lambda$addCommon$2((class_2474.class_5124)copperPlatforms, arg_0));
    }

    private void addTools() {
        this.tag(TinkerTags.Blocks.WORKBENCHES).add(new Object[]{class_2246.field_9980, TinkerTables.craftingStation.get()}).addOptionalTag(new class_2960("c:workbench"));
        this.tag(TinkerTags.Blocks.TABLES).add(new Object[]{TinkerTables.craftingStation.get(), TinkerTables.partBuilder.get(), TinkerTables.tinkerStation.get()});
        this.tag(TinkerTags.Blocks.HARVESTABLE_STACKABLE).add(new Object[]{class_2246.field_10424, class_2246.field_10463});
        this.tag(TinkerTags.Blocks.HARVESTABLE_CROPS).forceAddTag(class_3481.field_20341).addOptionalTag(new class_2960("c", "crops")).add((Object)class_2246.field_9974);
        this.tag(TinkerTags.Blocks.HARVESTABLE_INTERACT).add((Object)class_2246.field_16999);
        this.tag(TinkerTags.Blocks.HARVESTABLE).add(new Object[]{class_2246.field_10261, class_2246.field_20422, class_2246.field_20421}).addTag(TinkerTags.Blocks.HARVESTABLE_CROPS).addTag(TinkerTags.Blocks.HARVESTABLE_INTERACT).addTag(TinkerTags.Blocks.HARVESTABLE_STACKABLE);
        this.tag(TinkerTags.Blocks.TREE_LOGS).addTag(class_3481.field_15475);
        this.tag(TinkerTags.Blocks.CHRYSOPHILITE_ORES).forceAddTag(Tags.Blocks.ORES_GOLD).add((Object)class_2246.field_23880);
    }

    private void addWorld() {
        this.tag(TinkerTags.Blocks.ORES_COBALT).add((Object)TinkerWorld.cobaltOre.get());
        this.tag((class_6862<class_2248>)Tags.Blocks.ORES).addTag(TinkerTags.Blocks.ORES_COBALT);
        this.tag((class_6862<class_2248>)Tags.Blocks.ORES_IN_GROUND_NETHERRACK).add((Object)TinkerWorld.cobaltOre.get());
        this.tag((class_6862<class_2248>)Tags.Blocks.ORE_RATES_SINGULAR).add((Object)TinkerWorld.cobaltOre.get());
        this.tag(TinkerTags.Blocks.RAW_BLOCK_COBALT).add((Object)TinkerWorld.rawCobaltBlock.get());
        this.tag((class_6862<class_2248>)Tags.Blocks.STORAGE_BLOCKS).addTag(TinkerTags.Blocks.RAW_BLOCK_COBALT);
        FabricTagProvider.FabricTagBuilder endermanHoldable = this.tag((class_6862<class_2248>)class_3481.field_15460);
        endermanHoldable.method_26792(TinkerTags.Blocks.CONGEALED_SLIME).method_26795((Object[])new class_2248[]{(class_2248)TinkerSmeltery.grout.get(), (class_2248)TinkerSmeltery.netherGrout.get()});
        this.tag(TinkerTags.Blocks.SLIMY_LOGS).addTag(TinkerWorld.greenheart.getLogBlockTag()).addTag(TinkerWorld.skyroot.getLogBlockTag()).addTag(TinkerWorld.bloodshroom.getLogBlockTag());
        this.tag(TinkerTags.Blocks.SLIMY_PLANKS).add(new Object[]{TinkerWorld.greenheart.get(), TinkerWorld.skyroot.get(), TinkerWorld.bloodshroom.get()});
        this.tag((class_6862<class_2248>)class_3481.field_15471).addTag(TinkerTags.Blocks.SLIMY_PLANKS);
        this.tag((class_6862<class_2248>)class_3481.field_15475).addTag(TinkerTags.Blocks.SLIMY_LOGS);
        this.addWoodTags(TinkerWorld.greenheart, false);
        this.addWoodTags(TinkerWorld.skyroot, false);
        this.addWoodTags(TinkerWorld.bloodshroom, false);
        FabricTagProvider.FabricTagBuilder slimeBlockTagAppender = this.tag(TinkerTags.Blocks.SLIME_BLOCK);
        FabricTagProvider.FabricTagBuilder congealedTagAppender = this.tag(TinkerTags.Blocks.CONGEALED_SLIME);
        for (SlimeType slimeType : SlimeType.values()) {
            slimeBlockTagAppender.method_26793((Object)((class_2248)TinkerWorld.slime.get((Enum)slimeType)));
            congealedTagAppender.method_26793((Object)((class_2248)TinkerWorld.congealedSlime.get((Enum)slimeType)));
        }
        FabricTagProvider.FabricTagBuilder leavesTagAppender = this.tag(TinkerTags.Blocks.SLIMY_LEAVES);
        FabricTagProvider.FabricTagBuilder wartTagAppender = this.tag((class_6862<class_2248>)class_3481.field_21954);
        FabricTagProvider.FabricTagBuilder saplingTagAppender = this.tag(TinkerTags.Blocks.SLIMY_SAPLINGS);
        for (SlimeType type3 : SlimeType.values()) {
            if (type3.isNether()) {
                wartTagAppender.method_26793((Object)((class_2248)TinkerWorld.slimeLeaves.get((Enum)type3)));
                endermanHoldable.method_26793((Object)((class_2248)TinkerWorld.slimeSapling.get((Enum)type3)));
                continue;
            }
            leavesTagAppender.method_26793((Object)((class_2248)TinkerWorld.slimeLeaves.get((Enum)type3)));
            saplingTagAppender.method_26793((Object)((class_2248)TinkerWorld.slimeSapling.get((Enum)type3)));
        }
        this.tag((class_6862<class_2248>)class_3481.field_15503).addTag(TinkerTags.Blocks.SLIMY_LEAVES);
        this.tag((class_6862<class_2248>)class_3481.field_15462).addTag(TinkerTags.Blocks.SLIMY_SAPLINGS);
        FabricTagProvider.FabricTagBuilder fabricTagBuilder = this.tag(TinkerTags.Blocks.SLIMY_GRASS);
        FabricTagProvider.FabricTagBuilder slimyNylium = this.tag(TinkerTags.Blocks.SLIMY_NYLIUM);
        FabricTagProvider.FabricTagBuilder slimySoil = this.tag(TinkerTags.Blocks.SLIMY_SOIL);
        for (SlimeType type4 : SlimeType.values()) {
            (type4.isNether() ? slimyNylium : fabricTagBuilder).method_26792(type4.getGrassBlockTag());
            slimySoil.method_26792(type4.getDirtBlockTag());
        }
        TinkerWorld.slimeGrass.forEach((dirtType, blockObj) -> blockObj.forEach((grassType, block) -> {
            this.tag(grassType.getGrassBlockTag()).add(block);
            this.tag(dirtType.getDirtBlockTag()).add(block);
        }));
        TinkerWorld.slimeDirt.forEach((type, block) -> this.tag(type.getDirtBlockTag()).add(block));
        endermanHoldable.method_26792(TinkerTags.Blocks.SLIMY_SOIL);
        this.tag(TinkerTags.Blocks.SKY_SLIME_SPAWN).add(new Object[]{TinkerWorld.earthGeode.getBlock(), TinkerWorld.earthGeode.getBudding()}).addTag(SlimeType.SKY.getGrassBlockTag());
        this.tag(TinkerTags.Blocks.EARTH_SLIME_SPAWN).add(new Object[]{TinkerWorld.skyGeode.getBlock(), TinkerWorld.skyGeode.getBudding()}).addTag(SlimeType.EARTH.getGrassBlockTag());
        this.tag(TinkerTags.Blocks.ENDER_SLIME_SPAWN).add(new Object[]{TinkerWorld.enderGeode.getBlock(), TinkerWorld.enderGeode.getBudding()}).addTag(SlimeType.ENDER.getGrassBlockTag());
        this.tag((class_6862<class_2248>)class_3481.field_23800).add(new Object[]{TinkerTables.castChest.get(), TinkerCommons.goldBars.get(), TinkerCommons.goldPlatform.get(), TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN), TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN_BRUTE), TinkerWorld.wallHeads.get((Enum)TinkerHeadType.PIGLIN), TinkerWorld.wallHeads.get((Enum)TinkerHeadType.PIGLIN_BRUTE)});
        this.tag((class_6862<class_2248>)class_3481.field_22465).add(new Object[]{TinkerWorld.heads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN), TinkerWorld.wallHeads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN)});
        this.tag(TinkerTags.Blocks.STONE).add(new Object[]{class_2246.field_10340, class_2246.field_10445, class_2246.field_9989});
        this.tag(TinkerTags.Blocks.GRANITE).add((Object)class_2246.field_10474);
        this.tag(TinkerTags.Blocks.DIORITE).add((Object)class_2246.field_10508);
        this.tag(TinkerTags.Blocks.ANDESITE).add((Object)class_2246.field_10115);
        this.tag(TinkerTags.Blocks.BLACKSTONE).add((Object)class_2246.field_23869);
        this.tag(TinkerTags.Blocks.DEEPSLATE).add(new Object[]{class_2246.field_28888, class_2246.field_29031});
        this.tag(TinkerTags.Blocks.BASALT).add((Object)class_2246.field_22091);
    }

    private void addSmeltery() {
        this.tag(TinkerTags.Blocks.SEARED_BRICKS).add(new Object[]{TinkerSmeltery.searedBricks.get(), TinkerSmeltery.searedFancyBricks.get(), TinkerSmeltery.searedTriangleBricks.get()});
        this.tag(TinkerTags.Blocks.SEARED_BLOCKS).add(new Object[]{TinkerSmeltery.searedStone.get(), TinkerSmeltery.searedCrackedBricks.get(), TinkerSmeltery.searedCobble.get(), TinkerSmeltery.searedPaver.get()}).addTag(TinkerTags.Blocks.SEARED_BRICKS);
        this.tag((class_6862<class_2248>)class_3481.field_15504).add(new Object[]{TinkerSmeltery.searedBricks.getWall(), TinkerSmeltery.searedCobble.getWall()});
        this.tag(TinkerTags.Blocks.SCORCHED_BLOCKS).add(new Object[]{TinkerSmeltery.scorchedStone.get(), TinkerSmeltery.polishedScorchedStone.get(), TinkerSmeltery.scorchedBricks.get(), TinkerSmeltery.scorchedRoad.get(), TinkerSmeltery.chiseledScorchedBricks.get()});
        this.tag((class_6862<class_2248>)class_3481.field_16584).add(new Object[]{TinkerSmeltery.scorchedBricks.getFence(), TinkerMaterials.nahuatl.getFence()});
        this.tag(TinkerTags.Blocks.CISTERN_CONNECTIONS).add(new Object[]{TinkerSmeltery.searedFaucet.get(), TinkerSmeltery.scorchedFaucet.get()});
        FabricTagProvider.FabricTagBuilder searedTankTagAppender = this.tag(TinkerTags.Blocks.SEARED_TANKS);
        TinkerSmeltery.searedTank.values().forEach(arg_0 -> ((class_2474.class_5124)searedTankTagAppender).method_26793(arg_0));
        FabricTagProvider.FabricTagBuilder scorchedTankTagAppender = this.tag(TinkerTags.Blocks.SCORCHED_TANKS);
        TinkerSmeltery.scorchedTank.values().forEach(arg_0 -> ((class_2474.class_5124)scorchedTankTagAppender).method_26793(arg_0));
        this.tag(TinkerTags.Blocks.HEATER_CONTROLLERS).add(new Object[]{TinkerSmeltery.searedMelter.get(), TinkerSmeltery.scorchedAlloyer.get()});
        this.tag(TinkerTags.Blocks.FUEL_TANKS).add((Object)TinkerSmeltery.searedHeater.get()).addTag(TinkerTags.Blocks.SEARED_TANKS).addTag(TinkerTags.Blocks.SCORCHED_TANKS);
        this.tag(TinkerTags.Blocks.SMELTERY_TANKS).addTag(TinkerTags.Blocks.SEARED_TANKS);
        this.tag(TinkerTags.Blocks.FOUNDRY_TANKS).addTag(TinkerTags.Blocks.SCORCHED_TANKS);
        this.tag(TinkerTags.Blocks.ALLOYER_TANKS).add(new Object[]{TinkerSmeltery.scorchedAlloyer.get(), TinkerSmeltery.searedMelter.get()}).addTag(TinkerTags.Blocks.SEARED_TANKS).addTag(TinkerTags.Blocks.SCORCHED_TANKS);
        this.tag(TinkerTags.Blocks.SMELTERY_FLOOR).addTag(TinkerTags.Blocks.SEARED_BLOCKS).add(new Object[]{TinkerSmeltery.searedDrain.get(), TinkerSmeltery.searedChute.get(), TinkerSmeltery.searedDuct.get()});
        this.tag(TinkerTags.Blocks.SMELTERY_WALL).addTag(TinkerTags.Blocks.SEARED_BLOCKS).addTag(TinkerTags.Blocks.SMELTERY_TANKS).add(new Object[]{TinkerSmeltery.searedGlass.get(), TinkerSmeltery.searedLadder.get(), TinkerSmeltery.searedDrain.get(), TinkerSmeltery.searedChute.get(), TinkerSmeltery.searedDuct.get()});
        this.tag(TinkerTags.Blocks.SMELTERY).addTag(TinkerTags.Blocks.SMELTERY_WALL).addTag(TinkerTags.Blocks.SMELTERY_FLOOR).addTag(TinkerTags.Blocks.SMELTERY_TANKS);
        this.tag(TinkerTags.Blocks.FOUNDRY_FLOOR).addTag(TinkerTags.Blocks.SCORCHED_BLOCKS).add(new Object[]{TinkerSmeltery.scorchedDrain.get(), TinkerSmeltery.scorchedChute.get(), TinkerSmeltery.scorchedDuct.get()});
        this.tag(TinkerTags.Blocks.FOUNDRY_WALL).addTag(TinkerTags.Blocks.SCORCHED_BLOCKS).addTag(TinkerTags.Blocks.FOUNDRY_TANKS).add(new Object[]{TinkerSmeltery.scorchedGlass.get(), TinkerSmeltery.scorchedLadder.get(), TinkerSmeltery.scorchedDrain.get(), TinkerSmeltery.scorchedChute.get(), TinkerSmeltery.scorchedDuct.get()});
        this.tag(TinkerTags.Blocks.FOUNDRY).addTag(TinkerTags.Blocks.FOUNDRY_WALL).addTag(TinkerTags.Blocks.FOUNDRY_FLOOR).addTag(TinkerTags.Blocks.FOUNDRY_TANKS);
        this.tag((class_6862<class_2248>)class_3481.field_22414).add(new Object[]{TinkerSmeltery.searedLadder.get(), TinkerSmeltery.scorchedLadder.get()});
        this.tag((class_6862<class_2248>)class_3481.field_17753).add((Object)TinkerCommons.obsidianPane.get());
    }

    private void addFluids() {
        this.tag((class_6862<class_2248>)class_3481.field_23209).add(new Object[]{TinkerFluids.magma.getBlock(), TinkerFluids.blazingBlood.getBlock()});
    }

    private void addHarvest() {
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33716, TinkerCommons.mudBricks);
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33713, TinkerCommons.lavawood, TinkerCommons.blazewood);
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33713, new Supplier[]{TinkerGadgets.punji});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33717, new Supplier[]{TinkerCommons.obsidianPane});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33719, new Supplier[]{TinkerCommons.ironPlatform});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33718, new Supplier[]{TinkerCommons.goldBars, TinkerCommons.goldPlatform, TinkerCommons.cobaltPlatform});
        this.tag((class_6862<class_2248>)class_3481.field_33715).addTag(TinkerTags.Blocks.COPPER_PLATFORMS);
        this.tag((class_6862<class_2248>)class_3481.field_33719).addTag(TinkerTags.Blocks.COPPER_PLATFORMS);
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33713, (class_6862<class_2248>)class_3481.field_33717, new BuildingBlockObject[]{TinkerMaterials.nahuatl});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33718, new Supplier[]{TinkerWorld.cobaltOre, TinkerWorld.rawCobaltBlock, TinkerMaterials.cobalt, TinkerMaterials.slimesteel, TinkerMaterials.amethystBronze, TinkerMaterials.roseGold, TinkerMaterials.pigIron});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33717, new Supplier[]{TinkerMaterials.queensSlime, TinkerMaterials.manyullyn, TinkerMaterials.hepatizon, TinkerMaterials.soulsteel, TinkerModifiers.silkyJewelBlock});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_NETHERITE_TOOL, new Supplier[]{TinkerMaterials.knightslime});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33716, TinkerWorld.congealedSlime, TinkerWorld.slimeDirt, TinkerWorld.vanillaSlimeGrass, TinkerWorld.earthSlimeGrass, TinkerWorld.skySlimeGrass, TinkerWorld.enderSlimeGrass, TinkerWorld.ichorSlimeGrass);
        TinkerWorld.slimeDirt.forEach((type, block) -> this.tag((class_6862<class_2248>)Objects.requireNonNull(type.getHarvestTier().getTag())).add(block));
        for (SlimeType dirt : SlimeType.values()) {
            for (SlimeType grass : SlimeType.values()) {
                class_1834 dirtTier = dirt.getHarvestTier();
                class_1834 grassTier = grass.getHarvestTier();
                class_1834 tier = dirtTier.method_8024() == grassTier.method_8024() ? (dirtTier.ordinal() > grassTier.ordinal() ? dirtTier : grassTier) : (dirtTier.method_8024() > grassTier.method_8024() ? dirtTier : grassTier);
                this.tag((class_6862<class_2248>)Objects.requireNonNull(tier.getTag())).add(TinkerWorld.slimeGrass.get((Object)dirt).get((Enum)grass));
            }
        }
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33714, TinkerWorld.slimeLeaves);
        this.tagLogs((class_6862<class_2248>)class_3481.field_33713, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, TinkerWorld.skyroot);
        this.tagLogs((class_6862<class_2248>)class_3481.field_33713, (class_6862<class_2248>)class_3481.field_33719, TinkerWorld.greenheart);
        this.tagLogs((class_6862<class_2248>)class_3481.field_33713, (class_6862<class_2248>)class_3481.field_33718, TinkerWorld.bloodshroom);
        this.tagPlanks((class_6862<class_2248>)class_3481.field_33716, TinkerWorld.greenheart, TinkerWorld.skyroot, TinkerWorld.bloodshroom);
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33713, new Supplier[]{TinkerWorld.skySlimeVine, TinkerWorld.enderSlimeVine});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, TinkerWorld.earthGeode, TinkerWorld.skyGeode, TinkerWorld.ichorGeode, TinkerWorld.enderGeode);
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33716, new Supplier[]{TinkerSmeltery.grout, TinkerSmeltery.netherGrout});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new BuildingBlockObject[]{TinkerSmeltery.searedStone, TinkerSmeltery.searedPaver, TinkerSmeltery.searedCobble, TinkerSmeltery.searedBricks});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedCrackedBricks, TinkerSmeltery.searedFancyBricks, TinkerSmeltery.searedTriangleBricks, TinkerSmeltery.searedLadder, TinkerSmeltery.searedGlass, TinkerSmeltery.searedGlassPane});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new BuildingBlockObject[]{TinkerSmeltery.scorchedBricks, TinkerSmeltery.scorchedRoad});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.scorchedStone, TinkerSmeltery.polishedScorchedStone, TinkerSmeltery.chiseledScorchedBricks, TinkerSmeltery.scorchedLadder, TinkerSmeltery.scorchedGlass, TinkerSmeltery.scorchedGlassPane});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, TinkerSmeltery.searedTank, TinkerSmeltery.scorchedTank);
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedLantern, TinkerSmeltery.searedFaucet, TinkerSmeltery.searedChannel, TinkerSmeltery.searedBasin, TinkerSmeltery.searedTable});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.scorchedLantern, TinkerSmeltery.scorchedFaucet, TinkerSmeltery.scorchedChannel, TinkerSmeltery.scorchedBasin, TinkerSmeltery.scorchedTable});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedHeater, TinkerSmeltery.searedMelter, TinkerSmeltery.scorchedAlloyer});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33719, new Supplier[]{TinkerSmeltery.searedDrain, TinkerSmeltery.searedChute, TinkerSmeltery.smelteryController});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33718, new Supplier[]{TinkerSmeltery.searedDuct, TinkerSmeltery.scorchedDuct});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33717, new Supplier[]{TinkerSmeltery.scorchedDrain, TinkerSmeltery.scorchedChute, TinkerSmeltery.foundryController});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33713, new Supplier[]{TinkerTables.craftingStation, TinkerTables.tinkerStation, TinkerTables.partBuilder, TinkerTables.tinkersChest, TinkerTables.partChest});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33719, new Supplier[]{TinkerTables.castChest});
        this.tagBlocks((class_6862<class_2248>)class_3481.field_33715, (class_6862<class_2248>)class_3481.field_33718, new Supplier[]{TinkerTables.tinkersAnvil, TinkerTables.scorchedAnvil});
        this.tag(TinkerTags.Blocks.MINABLE_WITH_MATTOCK).addTag(class_3481.field_33716).addTag(class_3481.field_15475).add(new Object[]{class_2246.field_28678, class_2246.field_10211, class_2246.field_28411, class_2246.field_10597, class_2246.field_20421, class_2246.field_20422, class_2246.field_10147, class_2246.field_10009, class_2246.field_10261, class_2246.field_10528, class_2246.field_10021, class_2246.field_10302, class_2246.field_10580, class_2246.field_10556, class_2246.field_10240});
        this.tag(TinkerTags.Blocks.MINABLE_WITH_PICKADZE).addTag(class_3481.field_33716).addTag(class_3481.field_33715);
        this.tag(TinkerTags.Blocks.MINABLE_WITH_HAND_AXE).addTag(class_3481.field_33713).addTag(class_3481.field_15503);
        this.tag(TinkerTags.Blocks.MINABLE_WITH_SHEARS).add(new Object[]{class_2246.field_28678, class_2246.field_10343, class_2246.field_10342, class_2246.field_28411, class_2246.field_10588, class_2246.field_10091, class_2246.field_10589, class_2246.field_23079, class_2246.field_23078, class_2246.field_10597, class_2246.field_22124, class_2246.field_22123}).forceAddTag(class_3481.field_28621).forceAddTag(class_3481.field_15503).forceAddTag(class_3481.field_15481).forceAddTag(class_3481.field_15462).forceAddTag(class_3481.field_20339).forceAddTag(class_3481.field_36267).forceAddTag(class_3481.field_15483);
        this.tag(TinkerTags.Blocks.MINABLE_WITH_SCYTHE).add(new Object[]{class_2246.field_10150, class_2246.field_10331, class_2246.field_28683, class_2246.field_28682, class_2246.field_9993, class_2246.field_10463, class_2246.field_9974, class_2246.field_28684, class_2246.field_28677, class_2246.field_10424, class_2246.field_16999}).addTag(class_3481.field_33714).forceAddTag(TinkerTags.Blocks.MINABLE_WITH_SHEARS).forceAddTag(class_3481.field_20341);
        this.tag(TinkerTags.Blocks.MINABLE_WITH_SWORD).add((Object)class_2246.field_10343).add(new Object[]{class_2246.field_10302, class_2246.field_10021, class_2246.field_10528, class_2246.field_16999, class_2246.field_10597, class_2246.field_28680, class_2246.field_28681, class_2246.field_28682, class_2246.field_28683, class_2246.field_28411, class_2246.field_10261, class_2246.field_10147, class_2246.field_10545}).forceAddTag(class_3481.field_15503).forceAddTag(class_3481.field_15462).forceAddTag(class_3481.field_20339).forceAddTag(class_3481.field_20341);
        this.tag(TinkerTags.Blocks.MINABLE_WITH_DAGGER).addTag(class_3481.field_33714).addTag(TinkerTags.Blocks.MINABLE_WITH_SWORD);
    }

    public String method_10321() {
        return "Tinkers Construct Block Tags";
    }

    @SafeVarargs
    private void tagBlocks(class_6862<class_2248> tag, Supplier<? extends class_2248> ... blocks) {
        FabricTagProvider.FabricTagBuilder appender = this.tag(tag);
        for (Supplier<? extends class_2248> block : blocks) {
            appender.method_26793((Object)block.get());
        }
    }

    private void tagBlocks(class_6862<class_2248> tag, GeodeItemObject ... blocks) {
        FabricTagProvider.FabricTagBuilder appender = this.tag(tag);
        for (GeodeItemObject geode : blocks) {
            appender.method_26793((Object)geode.getBlock());
            appender.method_26793((Object)geode.getBudding());
            for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.values()) {
                appender.method_26793((Object)geode.getBud(size));
            }
        }
    }

    private void tagBlocks(class_6862<class_2248> tag1, class_6862<class_2248> tag2, Supplier<? extends class_2248> ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    @SafeVarargs
    private void tagBlocks(class_6862<class_2248> tag, EnumObject<?, ? extends class_2248> ... blocks) {
        FabricTagProvider.FabricTagBuilder appender = this.tag(tag);
        for (EnumObject<?, ? extends class_2248> block : blocks) {
            block.forEach(arg_0 -> BlockTagProvider.lambda$tagBlocks$7((class_2474.class_5124)appender, arg_0));
        }
    }

    @SafeVarargs
    private void tagBlocks(class_6862<class_2248> tag1, class_6862<class_2248> tag2, EnumObject<?, ? extends class_2248> ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    private void tagBlocks(class_6862<class_2248> tag, BuildingBlockObject ... blocks) {
        FabricTagProvider.FabricTagBuilder appender = this.tag(tag);
        for (BuildingBlockObject block : blocks) {
            block.values().forEach(arg_0 -> ((class_2474.class_5124)appender).method_26793(arg_0));
        }
    }

    private void tagBlocks(class_6862<class_2248> tag1, class_6862<class_2248> tag2, BuildingBlockObject ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    private void tagLogs(class_6862<class_2248> tag1, class_6862<class_2248> tag2, WoodBlockObject ... blocks) {
        for (WoodBlockObject block : blocks) {
            this.tag(tag1).add(new Object[]{block.getLog(), block.getWood()});
            this.tag(tag2).add(new Object[]{block.getLog(), block.getWood()});
        }
    }

    private void tagPlanks(class_6862<class_2248> tag, WoodBlockObject ... blocks) {
        for (WoodBlockObject block : blocks) {
            this.tag(tag).add(new Object[]{block.get(), block.getSlab(), block.getStairs(), block.getFence(), block.getStrippedLog(), block.getStrippedWood(), block.getFenceGate(), block.getDoor(), block.getTrapdoor(), block.getPressurePlate(), block.getButton(), block.getSign(), block.getWallSign()});
        }
    }

    private void addMetalTags(MetalItemObject metal, boolean beacon) {
        this.tag((class_6862<class_2248>)metal.getBlockTag()).add((Object)metal.get());
        if (beacon) {
            this.tag((class_6862<class_2248>)class_3481.field_22275).addTag(metal.getBlockTag());
        }
        this.tag((class_6862<class_2248>)Tags.Blocks.STORAGE_BLOCKS).addTag(metal.getBlockTag());
    }

    private void addGlass(EnumObject<ClearStainedGlassBlock.GlassColor, ? extends class_2248> blockObj, String tagPrefix, class_2474.class_5124<class_2248> blockTag) {
        blockObj.forEach((color, block) -> {
            blockTag.method_26793(block);
            this.tag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("c", tagPrefix + color.method_15434()))).add(block);
        });
    }

    private void addWoodTags(WoodBlockObject object, boolean doesBurn) {
        this.tag((class_6862<class_2248>)class_3481.field_15468).add((Object)object.getSlab());
        this.tag((class_6862<class_2248>)class_3481.field_15502).add((Object)object.getStairs());
        this.tag((class_6862<class_2248>)object.getLogBlockTag()).add(new Object[]{object.getLog(), object.getStrippedLog(), object.getWood(), object.getStrippedWood()});
        this.tag((class_6862<class_2248>)class_3481.field_17619).add((Object)object.getFence());
        this.tag((class_6862<class_2248>)Tags.Blocks.FENCES_WOODEN).add((Object)object.getFence());
        this.tag((class_6862<class_2248>)class_3481.field_25147).add((Object)object.getFenceGate());
        this.tag((class_6862<class_2248>)Tags.Blocks.FENCE_GATES_WOODEN).add((Object)object.getFenceGate());
        this.tag((class_6862<class_2248>)class_3481.field_15494).add((Object)object.getDoor());
        this.tag((class_6862<class_2248>)class_3481.field_15491).add((Object)object.getTrapdoor());
        this.tag((class_6862<class_2248>)class_3481.field_15499).add((Object)object.getButton());
        this.tag((class_6862<class_2248>)class_3481.field_15477).add((Object)object.getPressurePlate());
        if (doesBurn) {
            this.tag((class_6862<class_2248>)class_3481.field_23210).addTag(object.getLogBlockTag());
        } else {
            this.tag((class_6862<class_2248>)class_3481.field_23208).add(new Object[]{object.get(), object.getSlab(), object.getStairs(), object.getFence(), object.getFenceGate(), object.getDoor(), object.getTrapdoor(), object.getPressurePlate(), object.getButton()}).addTag(object.getLogBlockTag());
        }
        this.tag((class_6862<class_2248>)class_3481.field_15472).add((Object)object.getSign());
        this.tag((class_6862<class_2248>)class_3481.field_15492).add((Object)object.getWallSign());
    }

    public FabricTagProvider.FabricTagBuilder tag(class_6862<class_2248> tag) {
        return this.getOrCreateTagBuilder(tag);
    }

    private static /* synthetic */ void lambda$tagBlocks$7(class_2474.class_5124 appender, class_2248 b) {
        appender.method_26793((Object)b);
    }

    private static /* synthetic */ void lambda$addCommon$2(class_2474.class_5124 copperPlatforms, PlatformBlock block) {
        copperPlatforms.method_26793((Object)block);
    }

    private static /* synthetic */ void lambda$addCommon$1(class_2474.class_5124 copperPlatforms, PlatformBlock block) {
        copperPlatforms.method_26793((Object)block);
    }

    private static /* synthetic */ void lambda$addCommon$0(class_2474.class_5124 silicaPanes, ClearStainedGlassPaneBlock pane) {
        silicaPanes.method_26793((Object)pane);
    }
}

