/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.multiblock;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ServantTileEntity
extends MantleBlockEntity
implements IServantLogic {
    private static final String TAG_MASTER_POS = "masterPos";
    private static final String TAG_MASTER_BLOCK = "masterBlock";
    @Nullable
    private class_2338 masterPos;
    @Nullable
    private class_2248 masterBlock;

    public ServantTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean hasMaster() {
        return this.masterPos != null;
    }

    protected void setMaster(@Nullable class_2338 master, @Nullable class_2248 block) {
        this.masterPos = master;
        this.masterBlock = block;
        this.setChangedFast();
    }

    protected boolean validateMaster() {
        if (this.masterPos == null) {
            return false;
        }
        assert (this.field_11863 != null);
        if (this.field_11863.method_8320(this.masterPos).method_26204() == this.masterBlock) {
            return true;
        }
        this.setMaster(null, null);
        return false;
    }

    @Override
    public boolean isValidMaster(IMasterLogic master) {
        if (this.validateMaster()) {
            return master.getMasterPos().equals((Object)this.masterPos);
        }
        return true;
    }

    @Override
    public void notifyMasterOfChange(class_2338 pos, class_2680 state) {
        if (this.validateMaster()) {
            assert (this.masterPos != null);
            BlockEntityHelper.get(IMasterLogic.class, (class_1922)this.field_11863, (class_2338)this.masterPos).ifPresent(te -> te.notifyChange(this, pos, state));
        }
    }

    @Override
    public void setPotentialMaster(IMasterLogic master) {
        class_2338 newMaster = master.getMasterPos();
        if (newMaster.equals((Object)this.masterPos)) {
            this.masterBlock = master.getMasterBlock().method_26204();
            this.setChangedFast();
        } else if (!this.validateMaster()) {
            this.setMaster(newMaster, master.getMasterBlock().method_26204());
        }
    }

    @Override
    public void removeMaster(IMasterLogic master) {
        if (this.masterPos != null && this.masterPos.equals((Object)master.getMasterPos())) {
            this.setMaster(null, null);
        }
    }

    protected void readMaster(class_2487 tags) {
        class_2960 masterBlockName;
        class_2338 masterPos = TagUtil.readPos(tags, TAG_MASTER_POS);
        class_2248 masterBlock = null;
        if (masterPos != null && tags.method_10573(TAG_MASTER_BLOCK, 8) && (masterBlockName = class_2960.method_12829((String)tags.method_10558(TAG_MASTER_BLOCK))) != null && class_2378.field_11146.method_10250(masterBlockName)) {
            masterBlock = (class_2248)class_2378.field_11146.method_10223(masterBlockName);
        }
        if (masterBlock != null) {
            this.masterPos = masterPos;
            this.masterBlock = masterBlock;
        }
    }

    public void method_11014(class_2487 tags) {
        super.method_11014(tags);
        this.readMaster(tags);
    }

    protected class_2487 writeMaster(class_2487 tags) {
        if (this.masterPos != null && this.masterBlock != null) {
            tags.method_10566(TAG_MASTER_POS, (class_2520)TagUtil.writePos(this.masterPos));
            tags.method_10582(TAG_MASTER_BLOCK, Objects.requireNonNull(class_2378.field_11146.method_10221((Object)this.masterBlock)).toString());
        }
        return tags;
    }

    public void method_11007(class_2487 tags) {
        super.method_11007(tags);
        this.writeMaster(tags);
    }

    @Override
    @Nullable
    public class_2338 getMasterPos() {
        return this.masterPos;
    }
}

