/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.fabricators_of_create.porting_lib.util.EffectRenderer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_4081;
import net.minecraft.class_4587;
import net.minecraft.class_485;
import net.minecraft.class_5134;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.transfer.item.ItemHandlerHelper;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.capability.PiggybackCapability;
import slimeknights.tconstruct.gadgets.capability.PiggybackHandler;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.client.RenderUtils;

public class PiggyBackPackItem
extends TooltipItem {
    private static final int MAX_ENTITY_STACK = 3;

    public PiggyBackPackItem(class_1792.class_1793 props) {
        super(props);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 playerIn, class_1309 target, class_1268 hand) {
        class_1799 chestArmor = playerIn.method_6118(class_1304.field_6174);
        if (chestArmor.method_7909() != this && playerIn.method_31548().method_7376() == -1) {
            return class_1269.field_5811;
        }
        if (this.pickupEntity(playerIn, (class_1297)target)) {
            if (chestArmor.method_7909() != this) {
                ItemHandlerHelper.giveItemToPlayer((class_1657)playerIn, (class_1799)chestArmor);
                chestArmor = class_1799.field_8037;
            }
            if (chestArmor.method_7960()) {
                playerIn.method_5673(class_1304.field_6174, stack.method_7971(1));
            } else if (chestArmor.method_7947() < this.getEntitiesCarriedCount((class_1309)playerIn)) {
                stack.method_7971(1);
                chestArmor.method_7933(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    private boolean pickupEntity(class_1657 player, class_1297 target) {
        int count;
        if (player.method_5770().field_9236 || target.method_5864().method_20210(TinkerTags.EntityTypes.PIGGYBACKPACK_BLACKLIST)) {
            return false;
        }
        if (target.method_5854() == player || player.method_5854() == target) {
            return false;
        }
        class_1657 toRide = player;
        for (count = 0; toRide.method_5782() && count < 3; ++count) {
            toRide = (class_1297)toRide.method_5685().get(0);
            if (!(toRide instanceof class_1657) || !(target instanceof class_1657)) continue;
            return false;
        }
        if (!toRide.method_5782() && count < 3 && target.method_5873((class_1297)toRide, true)) {
            if (player instanceof class_3222) {
                TinkerNetwork.getInstance().sendVanillaPacket((class_1297)player, (class_2596<?>)new class_2752((class_1297)player));
            }
            return true;
        }
        return false;
    }

    private int getEntitiesCarriedCount(class_1309 player) {
        int count = 0;
        class_1309 ridden = player;
        while (ridden.method_5782()) {
            ++count;
            ridden = (class_1297)ridden.method_5685().get(0);
        }
        return count;
    }

    public void matchCarriedEntitiesToCount(class_1309 player, int maxCount) {
        int count = 0;
        class_1309 ridden = player;
        while (ridden.method_5782()) {
            ridden = (class_1297)ridden.method_5685().get(0);
            if (++count <= maxCount) continue;
            ridden.method_5848();
        }
    }

    public void method_7888(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        class_1309 livingEntity;
        if (entityIn instanceof class_1309 && (livingEntity = (class_1309)entityIn).method_6118(class_1304.field_6174) == stack && entityIn.method_5782()) {
            int amplifier = this.getEntitiesCarriedCount(livingEntity) - 1;
            livingEntity.method_6092(new class_1293((class_1291)TinkerGadgets.carryEffect.get(), 2, amplifier, true, false));
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return ImmutableMultimap.of();
    }

    public static class CarryPotionEffect
    extends TinkerEffect {
        static final String UUID = "ff4de63a-2b24-11e6-b67b-9e71128cae77";

        public CarryPotionEffect() {
            super(class_4081.field_18273, true);
            this.method_5566(class_5134.field_23719, UUID, -0.05, class_1322.class_1323.field_6331);
        }

        public boolean method_5552(int duration, int amplifier) {
            return true;
        }

        public void method_5572(@Nonnull class_1309 livingEntityIn, int p_76394_2_) {
            class_1799 chestArmor = livingEntityIn.method_6118(class_1304.field_6174);
            if (chestArmor.method_7960() || chestArmor.method_7909() != TinkerGadgets.piggyBackpack.get()) {
                ((PiggyBackPackItem)TinkerGadgets.piggyBackpack.get()).matchCarriedEntitiesToCount(livingEntityIn, 0);
            } else {
                ((PiggyBackPackItem)TinkerGadgets.piggyBackpack.get()).matchCarriedEntitiesToCount(livingEntityIn, chestArmor.method_7947());
                if (!livingEntityIn.method_5770().field_9236) {
                    PiggybackCapability.PIGGYBACK.maybeGet((Object)livingEntityIn).ifPresent(PiggybackHandler::updatePassengers);
                }
            }
        }

        @Override
        public void initializeClient(Consumer<EffectRenderer> consumer) {
            consumer.accept(new EffectRenderer(){

                public void renderInventoryEffect(class_1293 effect, class_485<?> gui, class_4587 matrices, int x, int y, float z) {
                    this.renderHUDEffect(effect, (class_332)gui, matrices, x, y, z, 1.0f);
                }

                public void renderHUDEffect(class_1293 effect, class_332 gui, class_4587 matrices, int x, int y, float z, float alpha) {
                    RenderUtils.setup(Icons.ICONS);
                    ElementScreen element = switch (effect.method_5578()) {
                        case 0 -> Icons.PIGGYBACK_1;
                        case 1 -> Icons.PIGGYBACK_2;
                        default -> Icons.PIGGYBACK_3;
                    };
                    element.draw(matrices, x + 6, y + 7);
                }
            });
        }
    }
}

