/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.library.client.RenderUtils;

public final class GuiUtil {
    public static void drawBackground(class_4587 matrices, class_465<?> screen, class_2960 background) {
        RenderUtils.setup(background);
        screen.method_25302(matrices, screen.field_2776, screen.field_2800, 0, 0, screen.field_2792, screen.field_2779);
    }

    @Deprecated
    public static void drawContainerNames(class_4587 matrices, class_465<?> screen, class_327 font, class_2561 invName) {
        String name = screen.method_25440().getString();
        font.method_1729(matrices, name, (float)screen.field_2792 / 2.0f - (float)font.method_1727(name) / 2.0f, 6.0f, 0x404040);
        font.method_30883(matrices, invName, 8.0f, (float)(screen.field_2779 - 96 + 2), 0x404040);
    }

    public static boolean isHovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static boolean isTankHovered(int mouseX, int mouseY, int amount, int capacity, int x, int y, int width, int height) {
        if (mouseX < x || mouseX > x + width || mouseY > y + height) {
            return false;
        }
        int topHeight = height - height * amount / capacity;
        return mouseY > y + topHeight;
    }

    public static void renderFluidTank(class_4587 matrices, class_465<?> screen, FluidStack stack, long capacity, int x, int y, int width, int height, int depth) {
        GuiUtil.renderFluidTank(matrices, screen, stack, stack.getAmount(), capacity, x, y, width, height, depth);
    }

    public static void renderFluidTank(class_4587 matrices, class_465<?> screen, FluidStack stack, long amount, long capacity, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty() && capacity > 0L) {
            int maxY = y + height;
            long fluidHeight = Math.min((long)height * amount / capacity, (long)height);
            GuiUtil.renderTiledFluid(matrices, screen, stack, x, (long)maxY - fluidHeight, width, fluidHeight, depth);
        }
    }

    public static void renderTiledFluid(class_4587 matrices, class_465<?> screen, FluidStack stack, int x, long y, int width, long height, int depth) {
        if (!stack.isEmpty()) {
            class_1058 fluidSprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(stack.getFluid().getAttributes().getStillTexture(stack));
            RenderUtils.setColorRGBA(stack.getFluid().getAttributes().getColor(stack));
            GuiUtil.renderTiledTextureAtlas(matrices, screen, fluidSprite, x, y, width, height, depth, stack.getFluid().getAttributes().isGaseous(stack));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTiledTextureAtlas(class_4587 matrices, class_465<?> screen, class_1058 sprite, int x, long y, int width, long height, int depth, boolean upsideDown) {
        RenderUtils.bindTexture(sprite.method_24119().method_24106());
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        float u1 = sprite.method_4594();
        float v1 = sprite.method_4593();
        int spriteHeight = sprite.method_4595();
        int spriteWidth = sprite.method_4578();
        int startX = x + screen.field_2776;
        long startY = y + (long)screen.field_2800;
        do {
            long renderHeight = Math.min((long)spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.method_4570((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            int x2 = startX;
            int widthLeft = width;
            class_1159 matrix = matrices.method_23760().method_23761();
            do {
                int renderWidth = Math.min(spriteWidth, widthLeft);
                widthLeft -= renderWidth;
                float u2 = sprite.method_4580((double)(16.0f * (float)renderWidth / (float)spriteWidth));
                if (upsideDown) {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v2, v1);
                } else {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                }
                x2 += renderWidth;
            } while (widthLeft > 0);
            startY += renderHeight;
        } while (height > 0L);
        builder.method_1326();
        RenderSystem.enableDepthTest();
        class_286.method_1309((class_287)builder);
    }

    private static void buildSquare(class_1159 matrix, class_287 builder, int x1, int x2, long y1, long y2, int z, float u1, float u2, float v1, float v2) {
        builder.method_22918(matrix, (float)x1, (float)y2, (float)z).method_22913(u1, v2).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y1, (float)z).method_22913(u2, v1).method_1344();
        builder.method_22918(matrix, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_1344();
    }

    public static void drawProgressUp(class_4587 matrices, ElementScreen element, int x, int y, float progress) {
        int height = progress > 1.0f ? element.h : (progress < 0.0f ? 0 : (int)((double)(progress * (float)element.h) + 0.5));
        int deltaY = element.h - height;
        class_437.method_25290((class_4587)matrices, (int)x, (int)(y + deltaY), (float)element.x, (float)(element.y + deltaY), (int)element.w, (int)height, (int)element.texW, (int)element.texH);
    }

    public static void renderHighlight(class_4587 matrices, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        class_332.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    private GuiUtil() {
    }
}

