/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.util.FluidAttributes;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.MantleRenderTypes;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;

public final class RenderUtils {
    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void setup(class_2960 texture, float red, float green, float blue, float alpha) {
        RenderUtils.bindTexture(texture);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setup(class_2960 texture) {
        RenderUtils.setup(texture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTransparentCuboid(class_4587 matrices, class_4597 buffer, FluidCuboid cube, FluidStack fluid, int opacity, int light) {
        if (opacity < 0 || fluid.isEmpty()) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        class_1058 still = FluidRenderer.getBlockSprite((class_2960)attributes.getStillTexture());
        class_1058 flowing = FluidRenderer.getBlockSprite((class_2960)attributes.getFlowingTexture());
        boolean isGas = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid.getType());
        light = FluidRenderer.withBlockLight((int)light, (int)attributes.getLuminosity(fluid));
        int color = FluidVariantRendering.getColor((FluidVariant)fluid.getType());
        if (opacity < 255) {
            int alpha = (color >> 24 & 0xFF) * opacity / 255;
            color = color & 0xFFFFFF | alpha << 24;
        }
        FluidRenderer.renderCuboid((class_4587)matrices, (class_4588)buffer.getBuffer(MantleRenderTypes.FLUID), (FluidCuboid)cube, (class_1058)still, (class_1058)flowing, (class_1160)cube.getFromScaled(), (class_1160)cube.getToScaled(), (int)color, (int)light, (boolean)isGas);
    }

    public static void renderFluidTank(class_4587 matrices, class_4597 buffer, FluidCuboid cube, FluidTankAnimated tank, int light, float partialTicks, boolean flipGas) {
        FluidStack liquid = tank.getFluid();
        long capacity = tank.getCapacity();
        if (!liquid.isEmpty() && capacity > 0L) {
            float offset = tank.getRenderOffset();
            if (offset > 1.2f || offset < -1.2f) {
                offset -= (offset / 12.0f + 0.1f) * partialTicks;
                tank.setRenderOffset(offset);
            } else {
                tank.setRenderOffset(0.0f);
            }
            FluidRenderer.renderScaledCuboid((class_4587)matrices, (class_4597)buffer, (FluidCuboid)cube, (FluidStack)liquid, (float)offset, (long)capacity, (int)light, (boolean)flipGas);
        } else {
            tank.setRenderOffset(0.0f);
        }
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtils.alpha(color) / 255.0f;
        float r = (float)RenderUtils.red(color) / 255.0f;
        float g = (float)RenderUtils.green(color) / 255.0f;
        float b = (float)RenderUtils.blue(color) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    private RenderUtils() {
    }
}

