/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.ContentMaterial;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class TierRangeMaterialSectionTransformer
extends BookTransformer {
    private static final Set<MaterialStatsId> VISIBLE_STATS = ImmutableSet.of((Object)((Object)HeadMaterialStats.ID), (Object)((Object)HandleMaterialStats.ID), (Object)((Object)ExtraMaterialStats.ID));
    private static final class_2960 KEY = TConstruct.getResource("material_tier");
    public static final TierRangeMaterialSectionTransformer INSTANCE = new TierRangeMaterialSectionTransformer();

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            JsonElement json = (JsonElement)section.extraData.get(KEY);
            if (json == null) continue;
            try {
                boolean detailed;
                int min = 0;
                int max = Integer.MAX_VALUE;
                class_6862<IMaterial> tag = null;
                if (json.isJsonPrimitive()) {
                    if (json.getAsJsonPrimitive().isNumber()) {
                        max = min = json.getAsInt();
                    } else {
                        tag = MaterialManager.getTag(JsonHelper.convertToResourceLocation((JsonElement)json, (String)KEY.toString()));
                    }
                    detailed = false;
                } else if (json.isJsonObject()) {
                    JsonObject jsonObject = json.getAsJsonObject();
                    if (jsonObject.has("tier")) {
                        max = min = class_3518.method_15260((JsonObject)jsonObject, (String)"tier");
                    } else {
                        min = class_3518.method_15282((JsonObject)jsonObject, (String)"min", (int)0);
                        max = class_3518.method_15282((JsonObject)jsonObject, (String)"max", (int)Integer.MAX_VALUE);
                    }
                    detailed = class_3518.method_15258((JsonObject)jsonObject, (String)"detailed", (boolean)false);
                    if (jsonObject.has("tag")) {
                        tag = MaterialManager.getTag(JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"tag"));
                    }
                } else {
                    throw new JsonSyntaxException("Invalid tconstruct:material_tier, expected number or JSON object");
                }
                AbstractMaterialSectionTransformer.createPages(book, section, new ValidMaterial(VISIBLE_STATS, min, max, tag), id -> new ContentMaterial((MaterialVariantId)id, detailed));
            }
            catch (JsonSyntaxException e) {
                TConstruct.LOG.error("Failed to parse material tier section data", (Throwable)e);
            }
        }
    }

    public record ValidMaterial(Set<MaterialStatsId> visibleStats, int min, int max, @Nullable class_6862<IMaterial> tag) implements Predicate<IMaterial>
    {
        @Deprecated
        public ValidMaterial(Set<MaterialStatsId> visibleStats, int min, int max) {
            this(visibleStats, min, max, null);
        }

        @Override
        public boolean test(IMaterial material) {
            int tier = material.getTier();
            if (tier < this.min || tier > this.max) {
                return false;
            }
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            MaterialId id = material.getIdentifier();
            if (this.tag != null && !registry.isInTag(id, this.tag)) {
                return false;
            }
            for (IMaterialStats stats : registry.getAllStats(id)) {
                if (!this.visibleStats.contains((Object)stats.getIdentifier())) continue;
                return true;
            }
            return false;
        }
    }
}

