/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public abstract class AbstractPartSpriteProvider {
    private final List<PartSpriteInfo> sprites = new ArrayList<PartSpriteInfo>();
    private final List<ToolSpriteBuilder> toolSprites = new ArrayList<ToolSpriteBuilder>();
    private boolean added = false;
    private final String modID;

    public abstract String getName();

    protected abstract void addAllSpites();

    protected void addTexture(class_2960 sprite, MaterialStatsId requiredStats) {
        this.sprites.add(new PartSpriteInfo(sprite, requiredStats));
    }

    protected void addTexture(String name, MaterialStatsId requiredStats) {
        this.addTexture(new class_2960(this.modID, name), requiredStats);
    }

    protected void addSprite(String name, MaterialStatsId requiredStats) {
        this.addTexture(new class_2960(this.modID, "item/tool/" + name), requiredStats);
    }

    protected void addPart(String name, MaterialStatsId requiredStats) {
        this.addSprite("parts/" + name, requiredStats);
    }

    protected void addHead(String name) {
        this.addPart(name, HeadMaterialStats.ID);
    }

    protected void addHandle(String name) {
        this.addPart(name, HandleMaterialStats.ID);
    }

    protected void addBinding(String name) {
        this.addPart(name, ExtraMaterialStats.ID);
    }

    protected ToolSpriteBuilder buildTool(class_2960 name) {
        ToolSpriteBuilder builder = new ToolSpriteBuilder(name);
        this.toolSprites.add(builder);
        return builder;
    }

    protected ToolSpriteBuilder buildTool(String name) {
        return this.buildTool(new class_2960(this.modID, name));
    }

    private void ensureSpritesAdded() {
        if (!this.added) {
            this.addAllSpites();
            this.toolSprites.forEach(ToolSpriteBuilder::build);
            this.toolSprites.clear();
            this.added = true;
        }
    }

    public List<PartSpriteInfo> getSprites() {
        this.ensureSpritesAdded();
        return this.sprites;
    }

    public void cleanCache() {
        this.sprites.clear();
        this.added = false;
    }

    public AbstractPartSpriteProvider(String modID) {
        this.modID = modID;
    }

    public static class PartSpriteInfo {
        private final class_2960 path;
        private final MaterialStatsId statType;
        private final transient Map<String, class_1011> sprites = new HashMap<String, class_1011>();

        @Nullable
        public class_1011 getTexture(AbstractSpriteReader spriteReader, String name) {
            if (this.sprites.containsKey(name)) {
                return this.sprites.get(name);
            }
            class_2960 fallbackPath = this.path;
            if (!name.isEmpty()) {
                fallbackPath = new class_2960(this.path.method_12836(), this.path.method_12832() + "_" + name);
            }
            class_1011 image = spriteReader.readIfExists(fallbackPath);
            this.sprites.put(name, image);
            return image;
        }

        public PartSpriteInfo(class_2960 path, MaterialStatsId statType) {
            this.path = path;
            this.statType = statType;
        }

        public class_2960 getPath() {
            return this.path;
        }

        public MaterialStatsId getStatType() {
            return this.statType;
        }
    }

    protected class ToolSpriteBuilder {
        private final class_2960 name;
        private final Map<String, MaterialStatsId> parts = new HashMap<String, MaterialStatsId>();
        private boolean hasLarge = false;

        public ToolSpriteBuilder addPart(String name, MaterialStatsId statTypes) {
            this.parts.put(name, statTypes);
            return this;
        }

        public ToolSpriteBuilder addBreakablePart(String name, MaterialStatsId statTypes) {
            this.addPart(name, statTypes);
            this.addPart("broken_" + name, statTypes);
            return this;
        }

        public ToolSpriteBuilder addHead(String name) {
            return this.addPart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addBreakableHead(String name) {
            return this.addBreakablePart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addHandle(String name) {
            return this.addPart(name, HandleMaterialStats.ID);
        }

        public ToolSpriteBuilder addBinding(String name) {
            return this.addPart(name, ExtraMaterialStats.ID);
        }

        public ToolSpriteBuilder withLarge() {
            this.hasLarge = true;
            return this;
        }

        private void addParts(String path) {
            for (Map.Entry<String, MaterialStatsId> entry : this.parts.entrySet()) {
                AbstractPartSpriteProvider.this.addTexture(new class_2960(this.name.method_12836(), "item/tool/" + path + "/" + entry.getKey()), entry.getValue());
            }
        }

        private void build() {
            this.addParts(this.name.method_12832());
            if (this.hasLarge) {
                this.addParts(this.name.method_12832() + "/large");
            }
        }

        private ToolSpriteBuilder(class_2960 name) {
            this.name = name;
        }
    }
}

