/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.utils.Util;

public class GreyToColorMapping
implements IColorMapping {
    public static final class_2960 NAME = TConstruct.getResource("grey_to_color");
    public static final Deserializer DESERIALIZER = new Deserializer();
    private final List<ColorMapping> mappings;
    private final Integer[] recolorCache = new Integer[256];
    private static final Interpolate<ColorMapping, Integer> INTERPOLATE_COLORS = (first, second, grey) -> {
        if (first == null) {
            assert (second != null);
            return second.color;
        }
        if (second == null) {
            return first.color;
        }
        return GreyToColorMapping.interpolateColors(first.color, first.grey, second.color, second.grey, grey);
    };
    private static final ToIntFunction<ColorMapping> GET_GREY = ColorMapping::grey;

    public int getColorForGrey(int grey) {
        if (this.recolorCache[grey] == null) {
            int calculated = GreyToColorMapping.getNearestByGrey(this.mappings, GET_GREY, grey, INTERPOLATE_COLORS);
            this.recolorCache[grey] = calculated;
        }
        return this.recolorCache[grey];
    }

    @Override
    public int mapColor(int color) {
        if (class_1011.method_24030((int)color) == 0) {
            return 0;
        }
        int grey = GreyToColorMapping.getGrey(color);
        return GreyToColorMapping.scaleColor(color, this.getColorForGrey(grey), grey);
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        JsonArray colors = new JsonArray();
        for (ColorMapping mapping : this.mappings) {
            JsonObject pair = new JsonObject();
            pair.addProperty("grey", (Number)mapping.grey);
            pair.addProperty("color", String.format("%08X", Util.translateColorBGR(mapping.color)));
            colors.add((JsonElement)pair);
        }
        object.add("palette", (JsonElement)colors);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromBlack() {
        return GreyToColorMapping.builder().addABGR(0, -16777216);
    }

    public static int interpolate(int a, int b, int x, int divisor) {
        return a + (b - a) * x / divisor;
    }

    public static int interpolateColors(int colorBefore, int greyBefore, int colorAfter, int greyAfter, int grey) {
        int diff = grey - greyBefore;
        int divisor = greyAfter - greyBefore;
        int alpha = GreyToColorMapping.interpolate(class_1011.method_24030((int)colorBefore), class_1011.method_24030((int)colorAfter), diff, divisor);
        int red = GreyToColorMapping.interpolate(class_1011.method_24033((int)colorBefore), class_1011.method_24033((int)colorAfter), diff, divisor);
        int green = GreyToColorMapping.interpolate(class_1011.method_24034((int)colorBefore), class_1011.method_24034((int)colorAfter), diff, divisor);
        int blue = GreyToColorMapping.interpolate(class_1011.method_24035((int)colorBefore), class_1011.method_24035((int)colorAfter), diff, divisor);
        return class_1011.method_24031((int)alpha, (int)blue, (int)green, (int)red);
    }

    public static int getGrey(int color) {
        return Math.max(class_1011.method_24033((int)color), Math.max(class_1011.method_24034((int)color), class_1011.method_24035((int)color)));
    }

    public static int scaleColor(int original, int newColor, int grey) {
        int blue;
        int green;
        int red;
        int alpha = class_1011.method_24030((int)original);
        if (alpha < 255) {
            newColor = newColor & 0xFFFFFF | alpha * class_1011.method_24030((int)newColor) / 255 << 24;
        }
        if ((red = class_1011.method_24033((int)original)) < grey) {
            newColor = newColor & 0xFFFFFF00 | (newColor & 0xFF) * red / grey & 0xFF;
        }
        if ((green = class_1011.method_24034((int)original)) < grey) {
            newColor = newColor & 0xFFFF00FF | (newColor & 0xFF00) * green / grey & 0xFF00;
        }
        if ((blue = class_1011.method_24035((int)original)) < grey) {
            newColor = newColor & 0xFF00FFFF | (newColor & 0xFF0000) * blue / grey & 0xFF0000;
        }
        return newColor;
    }

    public static <T, R> R getNearestByGrey(List<T> list, ToIntFunction<T> greyMap, int grey, Interpolate<T, R> interpolate) {
        int newGrey;
        int size = list.size();
        T first = list.get(0);
        if (size == 1 || grey <= greyMap.applyAsInt(first)) {
            return interpolate.interpolate(null, first, grey);
        }
        T second = list.get(1);
        for (int i = 1; i < size && grey >= (newGrey = greyMap.applyAsInt(second)); ++i) {
            if (grey == newGrey) {
                return interpolate.interpolate(first, second, grey);
            }
            first = second;
            second = list.get(i);
        }
        if (grey > greyMap.applyAsInt(second)) {
            return interpolate.interpolate(second, null, grey);
        }
        return interpolate.interpolate(first, second, grey);
    }

    protected GreyToColorMapping(List<ColorMapping> mappings) {
        this.mappings = mappings;
    }

    @FunctionalInterface
    public static interface Interpolate<T, R> {
        public R interpolate(@Nullable T var1, @Nullable T var2, int var3);
    }

    private record ColorMapping(int grey, int color) {
    }

    public static class Builder {
        private final ImmutableList.Builder<ColorMapping> builder = ImmutableList.builder();
        private int lastGrey = -1;

        private void checkGrey(int grey) {
            if (grey < 0 || grey > 255) {
                throw new IllegalArgumentException("Invalid grey value, must be between 0 and 255, inclusive");
            }
            if (grey <= this.lastGrey) {
                throw new IllegalArgumentException("Grey value must be greater than the previous value");
            }
            this.lastGrey = grey;
        }

        public Builder addABGR(int grey, int color) {
            this.checkGrey(grey);
            this.builder.add((Object)new ColorMapping(grey, color));
            return this;
        }

        public Builder addARGB(int grey, int color) {
            this.checkGrey(grey);
            this.builder.add((Object)new ColorMapping(grey, Util.translateColorBGR(color)));
            return this;
        }

        public GreyToColorMapping build() {
            ImmutableList list = this.builder.build();
            if (list.size() < 2) {
                throw new IllegalStateException("Too few colors in palette, must have at least 2");
            }
            return new GreyToColorMapping((List<ColorMapping>)list);
        }
    }

    protected static class Deserializer
    implements JsonDeserializer<GreyToColorMapping> {
        protected Deserializer() {
        }

        public GreyToColorMapping deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            JsonArray palette = class_3518.method_15261((JsonObject)object, (String)"palette");
            Builder paletteBuilder = GreyToColorMapping.builder();
            for (int i = 0; i < palette.size(); ++i) {
                JsonObject palettePair = class_3518.method_15295((JsonElement)palette.get(i), (String)("palette[" + i + "]"));
                int grey = class_3518.method_15260((JsonObject)palettePair, (String)"grey");
                int color = JsonHelper.parseColor((String)class_3518.method_15265((JsonObject)palettePair, (String)"color"));
                if (i == 0 && grey != 0) {
                    paletteBuilder.addABGR(0, -16777216);
                }
                paletteBuilder.addARGB(grey, color);
            }
            return paletteBuilder.build();
        }
    }
}

