/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.IEarlySafeManagerReloadListener;
import slimeknights.mantle.data.ResourceLocationSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialRenderInfoLoader
implements IEarlySafeManagerReloadListener,
IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialRenderInfoLoader.class);
    public static final MaterialRenderInfoLoader INSTANCE = new MaterialRenderInfoLoader();
    public static final String FOLDER = "tinkering/materials";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(MaterialStatsId.class, (Object)new ResourceLocationSerializer(MaterialStatsId::new, "tconstruct")).registerTypeHierarchyAdapter(ISpriteTransformer.class, ISpriteTransformer.SERIALIZER).registerTypeHierarchyAdapter(IColorMapping.class, IColorMapping.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private Map<MaterialVariantId, MaterialRenderInfo> renderInfos = ImmutableMap.of();

    public static void addResourceListener(ResourceManagerHelper manager) {
        manager.registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
    }

    private MaterialRenderInfoLoader() {
    }

    public Collection<MaterialRenderInfo> getAllRenderInfos() {
        return this.renderInfos.values();
    }

    public Optional<MaterialRenderInfo> getRenderInfo(MaterialVariantId variantId) {
        MaterialRenderInfo info;
        if (variantId.hasVariant() && (info = this.renderInfos.get(variantId)) != null) {
            return Optional.of(info);
        }
        return Optional.ofNullable(this.renderInfos.get(variantId.getId()));
    }

    public void onReloadSafe(class_3300 manager) {
        int trim = FOLDER.length() + 1;
        HashMap<MaterialVariantId, MaterialRenderInfo> map = new HashMap<MaterialVariantId, MaterialRenderInfo>();
        for (class_2960 location : manager.method_14488(FOLDER, loc -> loc.endsWith(".json"))) {
            String path = location.method_12832();
            String localPath = path.substring(trim, path.length() - 5);
            String variant = "";
            int slashIndex = localPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                variant = localPath.substring(slashIndex + 1);
                localPath = localPath.substring(0, slashIndex);
            }
            MaterialVariantId id = MaterialVariantId.create(location.method_12836(), localPath, variant);
            try {
                class_3298 resource = manager.method_14486(location);
                try {
                    InputStream inputstream = resource.method_14482();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        MaterialRenderInfoJson json = (MaterialRenderInfoJson)GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                        if (json == null) {
                            log.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)location);
                            continue;
                        }
                        MaterialRenderInfo old = map.put(id, this.loadRenderInfo(id, json));
                        if (old == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                log.error("Couldn't parse data file {} from {}", (Object)id, (Object)location, (Object)jsonparseexception);
            }
        }
        this.renderInfos = map;
        log.debug("Loaded material render infos: {}", (Object)Util.toIndentedStringList(map.keySet()));
        log.info("{} material render infos loaded", (Object)map.size());
    }

    private MaterialRenderInfo loadRenderInfo(MaterialVariantId material, MaterialRenderInfoJson json) {
        String[] fallback;
        int color = -1;
        if (json.getColor() != null) {
            color = JsonHelper.parseColor((String)json.getColor());
        }
        class_2960 texture = null;
        if (!json.isSkipUniqueTexture() && (texture = json.getTexture()) == null) {
            texture = material.getLocation('_');
        }
        if ((fallback = json.getFallbacks()) == null) {
            fallback = new String[]{};
        }
        return new MaterialRenderInfo(material, texture, fallback, color, json.getLuminosity());
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("");
    }
}

