/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelData;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_785;
import net.minecraft.class_806;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;

public class FluidTextureModel
implements IModelGeometry<FluidTextureModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Set<String> fluids;

    public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    private static String trimTextureName(String name) {
        if (name.charAt(0) == '#') {
            return name.substring(1);
        }
        return name;
    }

    public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 modelLocation) {
        class_1087 baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, modelLocation);
        Set fluidTextures = RetexturedModel.getAllRetextured((IModelConfiguration)owner, (SimpleBlockModel)this.model, this.fluids);
        List elements = this.model.getElements();
        int size = elements.size();
        BitSet fluidParts = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            class_785 part = (class_785)elements.get(i);
            long fluidFaces = part.field_4230.values().stream().filter(face -> fluidTextures.contains(FluidTextureModel.trimTextureName(face.field_4224))).count();
            if (fluidFaces <= 0L) continue;
            if (fluidFaces < (long)part.field_4230.size()) {
                TConstruct.LOG.warn("Mixed fluid and non-fluid elements in model {}, may cause unexpected results", (Object)modelLocation);
            }
            fluidParts.set(i);
        }
        return new Baked(baked, elements, owner, transform, fluidTextures, fluidParts);
    }

    public FluidTextureModel(SimpleBlockModel model, Set<String> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    private static class Baked
    extends DynamicBakedWrapper<class_1087> {
        private final Map<FluidStack, class_1087> cache = new ConcurrentHashMap<FluidStack, class_1087>();
        private final List<class_785> elements;
        private final IModelConfiguration owner;
        private final class_3665 transform;
        private final Set<String> fluids;
        private final BitSet fluidParts;

        protected Baked(class_1087 originalModel, List<class_785> elements, IModelConfiguration owner, class_3665 transform, Set<String> fluids, BitSet fluidParts) {
            super(originalModel);
            this.elements = elements;
            this.owner = owner;
            this.transform = transform;
            this.fluids = fluids;
            this.fluidParts = fluidParts;
        }

        private class_1087 getRetexturedModel(FluidStack fluid) {
            Function<class_4730, class_1058> spriteGetter = class_4730::method_24148;
            class_1058 particle = spriteGetter.apply(this.owner.resolveTexture("particle"));
            class_1093.class_1094 builder = new class_1093.class_1094(this.owner.useSmoothLighting(), this.owner.isSideLit(), this.owner.isShadedInGui(), this.owner.getCameraTransforms(), class_806.field_4292).method_4747(particle);
            int color = FluidVariantRendering.getColor((FluidVariant)fluid.getType());
            int luminosity = FluidVariantAttributes.getLuminance((FluidVariant)fluid.getType());
            RetexturedModel.RetexturedConfiguration textured = new RetexturedModel.RetexturedConfiguration(this.owner, this.fluids, FluidVariantRendering.getSprite((FluidVariant)fluid.getType()).method_4598());
            int size = this.elements.size();
            for (int i = 0; i < size; ++i) {
                class_785 element = this.elements.get(i);
                if (this.fluidParts.get(i)) {
                    ColoredBlockModel.bakePart((class_1093.class_1094)builder, (IModelConfiguration)textured, (class_785)element, (int)color, (int)luminosity, (class_3665)this.transform, spriteGetter, (class_2960)TankModel.BAKE_LOCATION);
                    continue;
                }
                SimpleBlockModel.bakePart((class_1093.class_1094)builder, (IModelConfiguration)this.owner, (class_785)element, (class_3665)this.transform, spriteGetter, (class_2960)TankModel.BAKE_LOCATION);
            }
            return builder.method_4746();
        }

        private class_1087 getCachedModel(FluidStack fluid) {
            return this.cache.computeIfAbsent(fluid, this::getRetexturedModel);
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
            IModelData data;
            FluidStack fluid;
            RenderAttachedBlockView renderAttachedBlockView;
            Object object;
            if (blockView instanceof RenderAttachedBlockView && (object = (renderAttachedBlockView = (RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos)) instanceof IModelData && (fluid = (FluidStack)(data = (IModelData)object).getData(IDisplayFluidListener.PROPERTY)) != null && !fluid.isEmpty()) {
                ((FabricBakedModel)this.getCachedModel(fluid)).emitBlockQuads(blockView, state, pos, randomSupplier, context);
                return;
            }
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
    }

    private static class Loader
    implements IModelLoader<FluidTextureModel> {
        private Loader() {
        }

        public void method_14491(class_3300 resourceManager) {
        }

        public FluidTextureModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            ImmutableSet fluids = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"fluids", class_3518::method_15287));
            return new FluidTextureModel(model, (Set<String>)fluids);
        }
    }
}

