/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.extensions.Vector3fExtensions;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_3518;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ModelHelper;

public class IncrementalFluidCuboid
extends FluidCuboid {
    private final int increments;

    public IncrementalFluidCuboid(class_1160 from, class_1160 to, Map<class_2350, FluidCuboid.FluidFace> faces, int increments) {
        super(from, to, faces);
        this.increments = increments;
    }

    public class_785 getPart(long amount, boolean gas) {
        class_1160 from = this.getFrom();
        class_1160 to = this.getTo();
        float minY = from.method_4945();
        float maxY = to.method_4945();
        if (gas) {
            from = from.method_23850();
            ((Vector3fExtensions)from).setY(maxY + (float)amount * (minY - maxY) / (float)this.increments);
        } else {
            to = to.method_23850();
            ((Vector3fExtensions)to).setY(minY + (float)amount * (maxY - minY) / (float)this.increments);
        }
        EnumMap<class_2350, class_783> faces = new EnumMap<class_2350, class_783>(class_2350.class);
        for (Map.Entry entry : this.getFaces().entrySet()) {
            class_2350 dir = (class_2350)entry.getKey();
            FluidCuboid.FluidFace face = (FluidCuboid.FluidFace)entry.getValue();
            boolean isFlowing = face.isFlowing();
            faces.put(dir, new class_783(null, 0, isFlowing ? "flowing_fluid" : "fluid", IncrementalFluidCuboid.getFaceUvs(from, to, dir, face.rotation(), isFlowing ? 0.5f : 1.0f)));
        }
        return new class_785(from, to, faces, null, false);
    }

    private static class_787 getFaceUvs(class_1160 from, class_1160 to, class_2350 side, int rotation, float scale) {
        float temp;
        float u2;
        float v1;
        float u1;
        float v2 = switch (side) {
            case class_2350.field_11033 -> {
                u1 = from.method_4943();
                v1 = 16.0f - to.method_4947();
                u2 = to.method_4943();
                yield 16.0f - from.method_4947();
            }
            case class_2350.field_11036 -> {
                u1 = from.method_4943();
                v1 = from.method_4947();
                u2 = to.method_4943();
                yield to.method_4947();
            }
            default -> {
                u1 = 16.0f - to.method_4943();
                v1 = 16.0f - to.method_4945();
                u2 = 16.0f - from.method_4943();
                yield 16.0f - from.method_4945();
            }
            case class_2350.field_11035 -> {
                u1 = from.method_4943();
                v1 = 16.0f - to.method_4945();
                u2 = to.method_4943();
                yield 16.0f - from.method_4945();
            }
            case class_2350.field_11039 -> {
                u1 = from.method_4947();
                v1 = 16.0f - to.method_4945();
                u2 = to.method_4947();
                yield 16.0f - from.method_4945();
            }
            case class_2350.field_11034 -> {
                u1 = 16.0f - to.method_4947();
                v1 = 16.0f - to.method_4945();
                u2 = 16.0f - from.method_4947();
                yield 16.0f - from.method_4945();
            }
        };
        if (rotation >= 180) {
            temp = v1;
            v1 = 16.0f - v2;
            v2 = 16.0f - temp;
        }
        if (rotation == 90 || rotation == 180) {
            temp = u1;
            u1 = 16.0f - u2;
            u2 = 16.0f - temp;
        }
        float[] uv = rotation % 180 == 90 ? new float[]{v1 * scale, u1 * scale, v2 * scale, u2 * scale} : new float[]{u1 * scale, v1 * scale, u2 * scale, v2 * scale};
        return new class_787(uv, rotation);
    }

    public static IncrementalFluidCuboid fromJson(JsonObject json) {
        class_1160 from = ModelHelper.arrayToVector((JsonObject)json, (String)"from");
        class_1160 to = ModelHelper.arrayToVector((JsonObject)json, (String)"to");
        Map faces = IncrementalFluidCuboid.getFaces((JsonObject)json);
        int increments = class_3518.method_15260((JsonObject)json, (String)"increments");
        return new IncrementalFluidCuboid(from, to, faces, increments);
    }

    public int getIncrements() {
        return this.increments;
    }
}

