/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelData;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.render.TransformTypeDependentItemBakedModel;
import io.github.fabricators_of_create.porting_lib.util.FluidAttributes;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_785;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.transfer.fluid.FluidTank;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.client.model.block.IncrementalFluidCuboid;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankModel
implements IModelGeometry<TankModel> {
    private static final Logger log = LogManager.getLogger(TankModel.class);
    protected static final class_2960 BAKE_LOCATION = TConstruct.getResource("dynamic_model_baking");
    public static final Loader LOADER = new Loader();
    protected final SimpleBlockModel model;
    @Nullable
    protected final SimpleBlockModel gui;
    protected final IncrementalFluidCuboid fluid;
    protected final boolean forceModelFluid;

    public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<class_4730> textures = new HashSet<class_4730>(this.model.getTextures(owner, modelGetter, missingTextureErrors));
        if (this.gui != null) {
            textures.addAll(this.gui.getTextures(owner, modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 location) {
        class_1087 baked;
        class_1087 bakedGui = baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        if (this.gui != null) {
            bakedGui = this.gui.bakeModel(owner, transform, overrides, spriteGetter, location);
        }
        return new Baked<TankModel>(owner, transform, baked, bakedGui, this);
    }

    public TankModel(SimpleBlockModel model, @Nullable SimpleBlockModel gui, IncrementalFluidCuboid fluid, boolean forceModelFluid) {
        this.model = model;
        this.gui = gui;
        this.fluid = fluid;
        this.forceModelFluid = forceModelFluid;
    }

    public static class Baked<T extends TankModel>
    extends BakedGuiUniqueModel {
        private final IModelConfiguration owner;
        private final class_3665 originalTransforms;
        protected final T original;
        private final Cache<FluidStack, class_1087> cache = CacheBuilder.newBuilder().maximumSize(64L).build();

        protected Baked(IModelConfiguration owner, class_3665 transforms, class_1087 baked, class_1087 gui, T original) {
            super(baked, gui);
            this.owner = owner;
            this.originalTransforms = transforms;
            this.original = original;
        }

        public class_806 method_4710() {
            return FluidPartOverride.INSTANCE;
        }

        private class_1087 bakeWithFluid(IModelConfiguration owner, SimpleBlockModel baseModel, class_785 fluid, int color, int luminosity) {
            Function<class_4730, class_1058> spriteGetter = class_4730::method_24148;
            class_1058 particle = spriteGetter.apply(owner.resolveTexture("particle"));
            class_1093.class_1094 builder = new class_1093.class_1094(owner.useSmoothLighting(), owner.isSideLit(), owner.isShadedInGui(), owner.getCameraTransforms(), class_806.field_4292).method_4747(particle);
            for (class_785 element : baseModel.getElements()) {
                SimpleBlockModel.bakePart((class_1093.class_1094)builder, (IModelConfiguration)owner, (class_785)element, (class_3665)this.originalTransforms, spriteGetter, (class_2960)BAKE_LOCATION);
            }
            ColoredBlockModel.bakePart((class_1093.class_1094)builder, (IModelConfiguration)owner, (class_785)fluid, (int)color, (int)luminosity, (class_3665)this.originalTransforms, spriteGetter, (class_2960)BAKE_LOCATION);
            return builder.method_4746();
        }

        private class_1087 getModel(FluidStack stack) {
            FluidAttributes attributes = stack.getFluid().getAttributes();
            int color = FluidVariantRendering.getColor((FluidVariant)stack.getType());
            int luminosity = attributes.getLuminosity(stack);
            ImmutableMap textures = ImmutableMap.of((Object)"fluid", (Object)new class_4730(class_1059.field_5275, FluidVariantRendering.getSprite((FluidVariant)stack.getType()).method_4598()), (Object)"flowing_fluid", (Object)new class_4730(class_1059.field_5275, FluidVariantRendering.getSprites((FluidVariant)stack.getType())[1].method_4598()));
            ExtraTextureConfiguration textured = new ExtraTextureConfiguration(this.owner, (Map)textures);
            class_785 fluid = ((TankModel)this.original).fluid.getPart(stack.getAmount(), FluidVariantAttributes.isLighterThanAir((FluidVariant)stack.getType()));
            Object baked = this.bakeWithFluid((IModelConfiguration)textured, ((TankModel)this.original).model, fluid, color, luminosity);
            if (((TankModel)this.original).gui != null) {
                baked = new BakedGuiUniqueModel((class_1087)baked, this.bakeWithFluid((IModelConfiguration)textured, ((TankModel)this.original).gui, fluid, color, 0));
            }
            return baked;
        }

        private class_1087 getCachedModel(FluidStack fluid) {
            try {
                return (class_1087)this.cache.get((Object)fluid, () -> this.getModel(fluid));
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                return this;
            }
        }

        private class_1087 getCachedModel(FluidStack fluid, long capacity) {
            int increments = ((TankModel)this.original).fluid.getIncrements();
            return this.getCachedModel(new FluidStack(fluid, class_3532.method_24156((long)(fluid.getAmount() * (long)increments / capacity), (long)1L, (long)increments)));
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
            RenderAttachedBlockView renderAttachedBlockView;
            Object object;
            if (blockView instanceof RenderAttachedBlockView && (object = (renderAttachedBlockView = (RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos)) instanceof IModelData) {
                FluidTank tank;
                IModelData data = (IModelData)object;
                if ((((TankModel)this.original).forceModelFluid || ((Boolean)Config.CLIENT.tankFluidModel.get()).booleanValue()) && data.hasProperty(ModelProperties.FLUID_TANK) && (tank = (FluidTank)data.getData(ModelProperties.FLUID_TANK)) != null && !tank.getFluid().isEmpty()) {
                    ((FabricBakedModel)this.getCachedModel(tank.getFluid(), tank.getCapacity())).emitBlockQuads(blockView, state, pos, randomSupplier, context);
                    return;
                }
            }
            ((FabricBakedModel)this.wrapped).emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }

        public IncrementalFluidCuboid getFluid() {
            return ((TankModel)this.original).fluid;
        }
    }

    public static class Loader
    implements IModelLoader<TankModel> {
        public void method_14491(class_3300 resourceManager) {
        }

        public TankModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
            SimpleBlockModel gui = null;
            if (modelContents.has("gui")) {
                gui = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)class_3518.method_15296((JsonObject)modelContents, (String)"gui"));
            }
            IncrementalFluidCuboid fluid = IncrementalFluidCuboid.fromJson(class_3518.method_15296((JsonObject)modelContents, (String)"fluid"));
            boolean forceModelFluid = class_3518.method_15258((JsonObject)modelContents, (String)"render_fluid_in_model", (boolean)false);
            return new TankModel(model, gui, fluid, forceModelFluid);
        }
    }

    private static class BakedGuiUniqueModel
    extends ForwardingBakedModel
    implements TransformTypeDependentItemBakedModel {
        private final class_1087 gui;

        public BakedGuiUniqueModel(class_1087 base, class_1087 gui) {
            this.wrapped = base;
            this.gui = gui;
        }

        public class_1087 handlePerspective(class_809.class_811 cameraTransformType, class_4587 mat) {
            if (!(this.gui instanceof TransformTypeDependentItemBakedModel) || !(this.wrapped instanceof TransformTypeDependentItemBakedModel)) {
                return this.wrapped;
            }
            if (cameraTransformType == class_809.class_811.field_4317) {
                return ((TransformTypeDependentItemBakedModel)this.gui).handlePerspective(cameraTransformType, mat);
            }
            return ((TransformTypeDependentItemBakedModel)this.wrapped).handlePerspective(cameraTransformType, mat);
        }
    }

    private static class FluidPartOverride
    extends class_806 {
        public static final FluidPartOverride INSTANCE = new FluidPartOverride();

        private FluidPartOverride() {
        }

        public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
            if (stack.method_7960() || !stack.method_7985()) {
                return model;
            }
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.isEmpty()) {
                return model;
            }
            return ((Baked)model).getCachedModel(tank.getFluid(), tank.getCapacity());
        }
    }
}

