/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.model.IModelConfiguration;
import io.github.fabricators_of_create.porting_lib.model.IModelGeometry;
import io.github.fabricators_of_create.porting_lib.model.IModelLoader;
import io.github.fabricators_of_create.porting_lib.model.PerspectiveMapWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.BakedItemModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialModel
implements IModelGeometry<MaterialModel> {
    private static final Logger log = LogManager.getLogger(MaterialModel.class);
    private static final Set<class_2960> SKIPPED_TEXTURES = new HashSet<class_2960>();
    public static final Loader LOADER = new Loader();
    @Nullable
    private final MaterialVariantId material;
    private final int index;
    private final class_241 offset;

    public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures = Sets.newHashSet();
        MaterialModel.getMaterialTextures(allTextures, owner, "texture", this.material);
        return allTextures;
    }

    private static boolean textureExists(class_3300 manager, class_2960 location) {
        return manager.method_18234(new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png"));
    }

    public static Predicate<class_4730> getTextureAdder(Collection<class_4730> allTextures, boolean logMissingTextures) {
        class_3300 manager = class_310.method_1551().method_1478();
        return mat -> {
            class_2960 loc = mat.method_24147();
            if (!class_1723.field_21668.equals((Object)mat.method_24144()) || MaterialModel.textureExists(manager, loc)) {
                allTextures.add((class_4730)mat);
                return true;
            }
            if (logMissingTextures && !SKIPPED_TEXTURES.contains(loc)) {
                SKIPPED_TEXTURES.add(loc);
                log.debug("Skipping loading texture '{}' as it does not exist in the resource pack", (Object)loc);
            }
            return false;
        };
    }

    public static void getMaterialTextures(Collection<class_4730> allTextures, IModelConfiguration owner, String textureName, @Nullable MaterialVariantId material) {
        class_4730 texture = owner.resolveTexture(textureName);
        allTextures.add(texture);
        if (!class_1047.method_4539().equals((Object)texture.method_24147())) {
            Predicate<class_4730> textureAdder = MaterialModel.getTextureAdder(allTextures, (Boolean)Config.CLIENT.logMissingMaterialTextures.get());
            if (material == null) {
                MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().forEach(info -> info.getTextureDependencies(textureAdder, texture));
            } else {
                MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material).ifPresent(info -> info.getTextureDependencies(textureAdder, texture));
            }
        }
    }

    public static class_1058 getPartQuads(Consumer<ImmutableList<class_777>> quadConsumer, IModelConfiguration owner, Function<class_4730, class_1058> spriteGetter, class_4590 transform, String name, int index, @Nullable MaterialVariantId material) {
        return MaterialModel.getPartQuads(quadConsumer, owner, spriteGetter, transform, name, index, material, null);
    }

    public static class_1058 getPartQuads(Consumer<ImmutableList<class_777>> quadConsumer, IModelConfiguration owner, Function<class_4730, class_1058> spriteGetter, class_4590 transform, String name, int index, @Nullable MaterialVariantId material, @Nullable ItemLayerPixels pixels) {
        return MaterialModel.getPartQuads(quadConsumer, owner.resolveTexture(name), spriteGetter, transform, index, material, pixels);
    }

    public static class_1058 getPartQuads(Consumer<ImmutableList<class_777>> quadConsumer, class_4730 texture, Function<class_4730, class_1058> spriteGetter, class_4590 transform, int index, @Nullable MaterialVariantId material, @Nullable ItemLayerPixels pixels) {
        Optional<MaterialRenderInfo> optional;
        int color = -1;
        int light = 0;
        class_1058 finalSprite = null;
        if (material != null && (optional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material)).isPresent()) {
            MaterialRenderInfo info = optional.get();
            MaterialRenderInfo.TintedSprite sprite = info.getSprite(texture, spriteGetter);
            finalSprite = sprite.sprite();
            color = sprite.color();
            light = info.getLuminosity();
        }
        if (finalSprite == null) {
            finalSprite = spriteGetter.apply(texture);
        }
        quadConsumer.accept((ImmutableList<class_777>)MantleItemLayerModel.getQuadsForSprite((int)color, (int)index, (class_1058)finalSprite, (class_4590)transform, (int)light, (ItemLayerPixels)pixels));
        return finalSprite;
    }

    private static class_1087 bakeInternal(IModelConfiguration owner, Function<class_4730, class_1058> spriteGetter, class_4590 transform, @Nullable MaterialVariantId material, int index, class_806 overrides) {
        MutableObject mutableList = new MutableObject();
        class_1058 particle = MaterialModel.getPartQuads(arg_0 -> ((MutableObject)mutableList).setValue(arg_0), owner, spriteGetter, transform, "texture", index, material);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((class_3665)owner.getCombinedTransform());
        return new BakedItemModel((ImmutableList)mutableList.getValue(), particle, Maps.immutableEnumMap((Map)transformMap), overrides, true, owner.isSideLit());
    }

    public class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 vanillaOverrides, class_2960 modelLocation) {
        class_4590 transforms = class_241.field_1340.method_1016(this.offset) ? class_4590.method_22931() : new class_4590(new class_1160(this.offset.field_1343 / 16.0f, -this.offset.field_1342 / 16.0f, 0.0f), null, null, null);
        class_806 overrides = class_806.field_4292;
        if (this.material == null) {
            overrides = new MaterialOverrideHandler(owner, this.index, transforms);
        }
        return MaterialModel.bakeInternal(owner, spriteGetter, transforms, this.material, this.index, overrides);
    }

    public static class_241 arrayToObject(JsonObject json, String name) {
        JsonArray array = class_3518.method_15261((JsonObject)json, (String)name);
        if (array.size() != 2) {
            throw new JsonParseException("Expected 2 " + name + " values, found: " + array.size());
        }
        float[] vec = new float[2];
        for (int i = 0; i < 2; ++i) {
            vec[i] = class_3518.method_15269((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return new class_241(vec[0], vec[1]);
    }

    public MaterialModel(@Nullable MaterialVariantId material, int index, class_241 offset) {
        this.material = material;
        this.index = index;
        this.offset = offset;
    }

    private static final class MaterialOverrideHandler
    extends class_806 {
        private final Map<MaterialVariantId, class_1087> cache = new ConcurrentHashMap<MaterialVariantId, class_1087>();
        private final IModelConfiguration owner;
        private final int index;
        private final class_4590 itemTransform;

        private MaterialOverrideHandler(IModelConfiguration owner, int index, class_4590 itemTransform) {
            this.owner = owner;
            this.index = index;
            this.itemTransform = itemTransform;
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
            MaterialVariantId material = IMaterialItem.getMaterialFromStack(stack);
            return this.cache.computeIfAbsent(material, this::bakeDynamic);
        }

        private class_1087 bakeDynamic(MaterialVariantId material) {
            return MaterialModel.bakeInternal(this.owner, class_4730::method_24148, this.itemTransform, material, this.index, class_806.field_4292);
        }
    }

    private static class Loader
    implements IModelLoader<MaterialModel> {
        private Loader() {
        }

        public void method_14491(class_3300 resourceManager) {
            SKIPPED_TEXTURES.clear();
        }

        public MaterialModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            int index = class_3518.method_15282((JsonObject)modelContents, (String)"index", (int)0);
            MaterialVariantId material = null;
            if (modelContents.has("material")) {
                material = MaterialVariantId.fromJson(modelContents, "material");
            }
            class_241 offset = class_241.field_1340;
            if (modelContents.has("offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "offset");
            }
            return new MaterialModel(material, index, offset);
        }
    }
}

