/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class BreakableDyedModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        class_4730 smallTexture = (class_4730)smallGetter.apply("");
        class_4730 brokenSmall = (class_4730)smallGetter.apply("_broken");
        class_4730 largeTexture = (class_4730)largeGetter.apply("");
        class_4730 brokenLarge = (class_4730)largeGetter.apply("_broken");
        if (smallTexture != null || brokenSmall != null || largeTexture != null || brokenLarge != null) {
            return new BreakableDyedModifierModel(smallTexture, brokenSmall, largeTexture, brokenLarge);
        }
        return null;
    };
    private final class_4730[] textures;

    public BreakableDyedModifierModel(@Nullable class_4730 normalSmall, @Nullable class_4730 brokenSmall, @Nullable class_4730 normalLarge, @Nullable class_4730 brokenLarge) {
        this.textures = new class_4730[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ModifierId modifier = entry.getId();
        ModDataNBT data = tool.getPersistentData();
        int color = -1;
        if (data.contains(modifier, 3)) {
            color = data.getInt(modifier);
        }
        return new CacheKey(modifier, color);
    }

    @Override
    public ImmutableList<class_777> getQuads(IToolStackView tool, ModifierEntry modifier, Function<class_4730, class_1058> spriteGetter, class_4590 transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        ModifierId key;
        ModDataNBT data;
        class_4730 texture = this.textures[(isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0)];
        if (texture != null && (data = tool.getPersistentData()).contains(key = modifier.getId(), 3)) {
            return MantleItemLayerModel.getQuadsForSprite((int)(0xFF000000 | data.getInt(key)), (int)-1, (class_1058)spriteGetter.apply(texture), (class_4590)transforms, (int)0, (ItemLayerPixels)pixels);
        }
        return ImmutableList.of();
    }

    private record CacheKey(ModifierId modifier, int color) {
    }
}

