/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import org.apache.commons.lang3.mutable.MutableObject;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BreakableMaterialModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        class_4730 smallTexture = BreakableMaterialModifierModel.stitchMaterialTextures(smallGetter, "");
        class_4730 brokenSmall = BreakableMaterialModifierModel.stitchMaterialTextures(smallGetter, "_broken");
        class_4730 largeTexture = BreakableMaterialModifierModel.stitchMaterialTextures(largeGetter, "");
        class_4730 brokenLarge = BreakableMaterialModifierModel.stitchMaterialTextures(largeGetter, "_broken");
        if (smallTexture != null || brokenSmall != null || largeTexture != null || brokenLarge != null) {
            return new BreakableMaterialModifierModel(smallTexture, brokenSmall, largeTexture, brokenLarge);
        }
        return null;
    };
    private final class_4730[] textures;

    @Nullable
    private static class_4730 stitchMaterialTextures(Function<String, class_4730> textureGetter, String name) {
        class_4730 baseTexture = textureGetter.apply(name);
        if (baseTexture != null) {
            for (MaterialRenderInfo info : MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos()) {
                class_2960 texture = info.getTexture();
                if (texture != null) {
                    textureGetter.apply(name + "_" + MaterialRenderInfo.getSuffix(texture));
                }
                for (String fallback : info.getFallbacks()) {
                    textureGetter.apply(name + "_" + fallback);
                }
            }
        }
        return baseTexture;
    }

    public BreakableMaterialModifierModel(@Nullable class_4730 normalSmall, @Nullable class_4730 brokenSmall, @Nullable class_4730 normalLarge, @Nullable class_4730 brokenLarge) {
        this.textures = new class_4730[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ModifierId modifier = entry.getId();
        return new CacheKey(modifier, tool.getPersistentData().getString(modifier));
    }

    @Nullable
    private static MaterialVariantId getMaterial(IToolStackView tool, Modifier modifier) {
        String material = tool.getPersistentData().getString(modifier.getId());
        if (!material.isEmpty()) {
            return MaterialVariantId.tryParse(material);
        }
        return null;
    }

    @Override
    public ImmutableList<class_777> getQuads(IToolStackView tool, ModifierEntry modifier, Function<class_4730, class_1058> spriteGetter, class_4590 transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        class_4730 texture = this.textures[(isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0)];
        if (texture != null) {
            MutableObject mutable = new MutableObject();
            MaterialModel.getPartQuads(arg_0 -> ((MutableObject)mutable).setValue(arg_0), texture, spriteGetter, transforms, -1, BreakableMaterialModifierModel.getMaterial(tool, modifier.getModifier()), pixels);
            return (ImmutableList)mutable.getValue();
        }
        return ImmutableList.of();
    }

    private record CacheKey(ModifierId modifier, String material) {
    }
}

