/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BreakableModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1, 0);
    private final class_4730[] sprites;
    private final int color;
    private final int luminosity;

    public BreakableModifierModel(@Nullable class_4730 normalSmall, @Nullable class_4730 brokenSmall, @Nullable class_4730 normalLarge, @Nullable class_4730 brokenLarge, int color, int luminosity) {
        this.color = color;
        this.luminosity = luminosity;
        this.sprites = new class_4730[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    public BreakableModifierModel(@Nullable class_4730 normalSmall, @Nullable class_4730 brokenSmall, @Nullable class_4730 normalLarge, @Nullable class_4730 brokenLarge) {
        this(normalSmall, brokenSmall, normalLarge, brokenLarge, -1, 0);
    }

    @Override
    public ImmutableList<class_777> getQuads(IToolStackView tool, ModifierEntry entry, Function<class_4730, class_1058> spriteGetter, class_4590 transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        int index = (isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0);
        return MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)-1, (class_1058)spriteGetter.apply(this.sprites[index]), (class_4590)transforms, (int)this.luminosity, (ItemLayerPixels)pixels);
    }

    private static class Unbaked
    implements IUnbakedModifierModel {
        private final int color;
        private final int luminosity;

        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, class_4730> smallGetter, Function<String, class_4730> largeGetter) {
            class_4730 normalSmall = smallGetter.apply("");
            class_4730 brokenSmall = smallGetter.apply("_broken");
            class_4730 normalLarge = smallGetter.apply("");
            class_4730 brokenLarge = smallGetter.apply("_broken");
            if (normalSmall != null || brokenSmall != null || normalLarge != null || brokenLarge != null) {
                return new BreakableModifierModel(normalSmall, brokenSmall, normalLarge, brokenLarge, this.color, this.luminosity);
            }
            return null;
        }

        @Override
        public IUnbakedModifierModel configure(JsonObject data) {
            int color = JsonHelper.parseColor((String)class_3518.method_15253((JsonObject)data, (String)"color", (String)""));
            int luminosity = class_3518.method_15260((JsonObject)data, (String)"luminosity");
            if (color != this.color || luminosity != this.luminosity) {
                return new Unbaked(color, luminosity);
            }
            return this;
        }

        public Unbaked(int color, int luminosity) {
            this.color = color;
            this.luminosity = luminosity;
        }
    }
}

