/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import io.github.fabricators_of_create.porting_lib.model.ItemTextureQuadConverter;
import io.github.fabricators_of_create.porting_lib.util.FluidAttributes;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_3611;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class FluidModifierModel
extends NormalModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        class_4730 smallTexture = (class_4730)smallGetter.apply("");
        class_4730 largeTexture = (class_4730)largeGetter.apply("");
        class_4730 smallFull = (class_4730)smallGetter.apply("_full");
        class_4730 largeFull = (class_4730)largeGetter.apply("_full");
        if (smallTexture != null || largeTexture != null) {
            return new FluidModifierModel(smallTexture, largeTexture, smallFull, largeFull);
        }
        return null;
    };
    protected final class_4730[] fluidTextures;

    protected FluidModifierModel(@Nullable class_4730 smallTexture, @Nullable class_4730 largeTexture, class_4730[] fluidTextures) {
        super(smallTexture, largeTexture);
        this.fluidTextures = fluidTextures;
    }

    public FluidModifierModel(@Nullable class_4730 smallTexture, @Nullable class_4730 largeTexture, @Nullable class_4730 smallFull, @Nullable class_4730 largeFull) {
        this(smallTexture, largeTexture, new class_4730[]{smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        TankModifier tank;
        FluidStack fluid;
        Modifier modifier = entry.getModifier();
        if (modifier instanceof TankModifier && !(fluid = (tank = (TankModifier)modifier).getFluid(tool)).isEmpty()) {
            return new FluidModifierCacheKey(tank, fluid.getFluid());
        }
        return entry.getId();
    }

    @Nullable
    protected class_4730 getTemplate(TankModifier tank, IToolStackView tool, FluidStack fluid, boolean isLarge) {
        return this.fluidTextures[isLarge ? 1 : 0];
    }

    @Override
    public ImmutableList<class_777> getQuads(IToolStackView tool, ModifierEntry entry, Function<class_4730, class_1058> spriteGetter, class_4590 transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        class_4730 template;
        TankModifier tank;
        FluidStack fluid;
        ImmutableList quads = super.getQuads(tool, entry, spriteGetter, transforms, isLarge, startTintIndex, pixels);
        Modifier modifier = entry.getModifier();
        if (modifier instanceof TankModifier && !(fluid = (tank = (TankModifier)modifier).getFluid(tool)).isEmpty() && (template = this.getTemplate(tank, tool, fluid, isLarge)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(quads);
            FluidAttributes attributes = fluid.getFluid().getAttributes();
            class_1058 fluidSprite = spriteGetter.apply(new class_4730(class_1059.field_5275, FluidVariantRendering.getSprite((FluidVariant)fluid.getType()).method_4598()));
            int color = attributes.getColor(fluid);
            int luminosity = attributes.getLuminosity(fluid);
            class_1058 templateSprite = spriteGetter.apply(template);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((class_4590)transforms, (class_1058)templateSprite, (class_1058)fluidSprite, (float)0.468625f, (class_2350)class_2350.field_11043, (int)color, (int)-1, (int)luminosity));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((class_4590)transforms, (class_1058)templateSprite, (class_1058)fluidSprite, (float)0.531375f, (class_2350)class_2350.field_11035, (int)color, (int)-1, (int)luminosity));
            quads = builder.build();
        }
        return quads;
    }

    private record FluidModifierCacheKey(Modifier modifier, class_3611 fluid) {
    }
}

