/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4730;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.IEarlySafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class ModifierModelManager
implements IEarlySafeManagerReloadListener,
IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierModelManager.class);
    private static final String VISIBLE_MODIFIERS = "tinkering/modifiers.json";
    public static final ModifierModelManager INSTANCE = new ModifierModelManager();
    private static boolean eventFired = false;
    private static final Map<class_2960, IUnbakedModifierModel> MODIFIER_MODEL_OPTIONS = new HashMap<class_2960, IUnbakedModifierModel>();
    private static Map<ModifierId, IUnbakedModifierModel> modifierModels = Collections.emptyMap();

    public static void init(ResourceManagerHelper manager) {
        manager.registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
    }

    @Nullable
    private static IUnbakedModifierModel getLoader(String key, String name) {
        class_2960 loader = class_2960.method_12829((String)name);
        if (loader == null) {
            log.error("Skipping modifier " + key + " as " + name + " is an invalid loader name");
        } else {
            IUnbakedModifierModel model = MODIFIER_MODEL_OPTIONS.get(loader);
            if (model == null) {
                log.error("Skipping modifier " + key + " as the loader " + loader + " is unknown");
            } else {
                return model;
            }
        }
        return null;
    }

    public void onReloadSafe(class_3300 manager) {
        if (!eventFired) {
            new ModifierModelRegistrationEvent().sendEvent();
            eventFired = true;
        }
        HashMap<ModifierId, IUnbakedModifierModel> models = new HashMap<ModifierId, IUnbakedModifierModel>();
        List jsonFiles = JsonHelper.getFileInAllDomainsAndPacks((class_3300)manager, (String)VISIBLE_MODIFIERS, null);
        for (int i = jsonFiles.size() - 1; i >= 0; --i) {
            JsonObject json = (JsonObject)jsonFiles.get(i);
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ModifierId name = ModifierId.tryParse(key);
                if (name == null) {
                    log.error("Skipping invalid modifier key " + key + " as it is not a valid resource location");
                    continue;
                }
                if (models.containsKey((Object)name)) continue;
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonNull()) {
                    models.remove((Object)name);
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    IUnbakedModifierModel model = ModifierModelManager.getLoader(key, class_3518.method_15265((JsonObject)object, (String)"type"));
                    if (model == null) continue;
                    models.put(name, model.configure(object));
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    IUnbakedModifierModel model = ModifierModelManager.getLoader(key, element.getAsString());
                    if (model == null) continue;
                    models.put(name, model);
                    continue;
                }
                log.error("Skipping key " + key + " as the value is not a string or object");
            }
        }
        modifierModels = models;
    }

    private static class_4730 getModifierTexture(class_2960 modifierRoot, class_2960 modifierId, String suffix) {
        return new class_4730(class_1059.field_5275, new class_2960(modifierRoot.method_12836(), modifierRoot.method_12832() + modifierId.method_12836() + "_" + modifierId.method_12832() + suffix));
    }

    @Nullable
    private static class_4730 getTexture(List<class_2960> modifierRoots, @Nullable Predicate<class_4730> textureAdder, class_2960 modifier, String suffix) {
        if (textureAdder == null) {
            return null;
        }
        for (class_2960 root : modifierRoots) {
            class_4730 texture = ModifierModelManager.getModifierTexture(root, modifier, suffix);
            if (!textureAdder.test(texture)) continue;
            return texture;
        }
        return null;
    }

    public static Map<ModifierId, IBakedModifierModel> getModelsForTool(List<class_2960> smallModifierRoots, List<class_2960> largeModifierRoots, Collection<class_4730> textures) {
        if (modifierModels.isEmpty() || smallModifierRoots.isEmpty() && largeModifierRoots.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder modelMap = ImmutableMap.builder();
        Predicate<class_4730> smallTextureAdder = smallModifierRoots.isEmpty() ? null : MaterialModel.getTextureAdder(textures, (Boolean)Config.CLIENT.logMissingModifierTextures.get());
        Predicate<class_4730> largeTextureAdder = largeModifierRoots.isEmpty() ? null : MaterialModel.getTextureAdder(textures, (Boolean)Config.CLIENT.logMissingModifierTextures.get());
        for (Map.Entry<ModifierId, IUnbakedModifierModel> entry : modifierModels.entrySet()) {
            ModifierId id = entry.getKey();
            IUnbakedModifierModel model = entry.getValue();
            IBakedModifierModel toolModel = model.forTool(name -> ModifierModelManager.getTexture(smallModifierRoots, smallTextureAdder, id, name), name -> ModifierModelManager.getTexture(largeModifierRoots, largeTextureAdder, id, name));
            if (toolModel == null) continue;
            modelMap.put((Object)id, (Object)toolModel);
        }
        return modelMap.build();
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("modifiers");
    }

    private ModifierModelManager() {
    }

    public static class ModifierModelRegistrationEvent {
        public static Event<ModifierModels> EVENT = EventFactory.createArrayBacked(ModifierModels.class, callbacks -> modifierModels -> {
            for (ModifierModels e : callbacks) {
                e.registerModels(modifierModels);
            }
        });

        public void registerModel(class_2960 name, IUnbakedModifierModel model) {
            MODIFIER_MODEL_OPTIONS.put(name, model);
        }

        public void sendEvent() {
            ((ModifierModels)EVENT.invoker()).registerModels(this);
        }

        @FunctionalInterface
        public static interface ModifierModels {
            public void registerModels(ModifierModelRegistrationEvent var1);
        }
    }
}

