/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class NormalModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1, 0);
    private final class_4730[] textures;
    private final int color;
    private final int luminosity;

    public NormalModifierModel(@Nullable class_4730 smallTexture, @Nullable class_4730 largeTexture, int color, int luminosity) {
        this.color = color;
        this.luminosity = luminosity;
        this.textures = new class_4730[]{smallTexture, largeTexture};
    }

    public NormalModifierModel(@Nullable class_4730 smallTexture, @Nullable class_4730 largeTexture) {
        this(smallTexture, largeTexture, -1, 0);
    }

    @Override
    public ImmutableList<class_777> getQuads(IToolStackView tool, ModifierEntry entry, Function<class_4730, class_1058> spriteGetter, class_4590 transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        int index = isLarge ? 1 : 0;
        return MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)-1, (class_1058)spriteGetter.apply(this.textures[index]), (class_4590)transforms, (int)this.luminosity, (ItemLayerPixels)pixels);
    }

    private record Unbaked(int color, int luminosity) implements IUnbakedModifierModel
    {
        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, class_4730> smallGetter, Function<String, class_4730> largeGetter) {
            class_4730 smallTexture = smallGetter.apply("");
            class_4730 largeTexture = largeGetter.apply("");
            if (smallTexture != null || largeTexture != null) {
                return new NormalModifierModel(smallTexture, largeTexture, this.color, this.luminosity);
            }
            return null;
        }

        @Override
        public IUnbakedModifierModel configure(JsonObject data) {
            int color = JsonHelper.parseColor((String)class_3518.method_15253((JsonObject)data, (String)"color", (String)""));
            int luminosity = class_3518.method_15260((JsonObject)data, (String)"luminosity");
            if (color != this.color || luminosity != this.luminosity) {
                return new Unbaked(color, luminosity);
            }
            return this;
        }
    }
}

