/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.impl.datagen.FabricTagBuilder;
import net.minecraft.class_2403;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3494;
import net.minecraft.class_6862;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.GenericDataProvider;

public abstract class AbstractTagProvider<T>
extends GenericDataProvider {
    private static final Logger log = LogManager.getLogger(AbstractTagProvider.class);
    protected final class_2403 generator;
    private final String modId;
    private final Predicate<class_2960> staticValuePredicate;
    private final Function<T, class_2960> keyGetter;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    protected final Map<class_2960, class_3494.class_3495> builders = Maps.newLinkedHashMap();

    protected AbstractTagProvider(class_2403 generator, String modId, String folder, Function<T, class_2960> keyGetter, Predicate<class_2960> staticValuePredicate, ExistingFileHelper existingFileHelper) {
        super(generator, class_3264.field_14190, folder);
        this.generator = generator;
        this.modId = modId;
        this.keyGetter = keyGetter;
        this.staticValuePredicate = staticValuePredicate;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", folder);
    }

    protected abstract void addTags();

    public void method_10319(class_2408 cache) throws IOException {
        this.builders.clear();
        this.addTags();
        this.builders.forEach((id, builder) -> {
            List<class_3494.class_5145> list = builder.method_26785().filter(value -> !value.comp_324().method_32832(this.staticValuePredicate, this.builders::containsKey)).filter(this::missing).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", id, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            this.saveThing(cache, (class_2960)id, builder.method_26788());
        });
    }

    private boolean missing(class_3494.class_5145 reference) {
        class_3494.class_3496 entry = reference.comp_324();
        if (entry instanceof class_3494.class_3497) {
            class_3494.class_3497 nonOptionalEntry = (class_3494.class_3497)entry;
            return !this.existingFileHelper.exists(nonOptionalEntry.field_15584, this.resourceType);
        }
        return false;
    }

    protected TagAppender<T> tag(class_6862<T> pTag) {
        return new TagAppender<T>(this.modId, this.getOrCreateRawBuilder(pTag), this.keyGetter);
    }

    protected class_3494.class_3495 getOrCreateRawBuilder(class_6862<T> pTag) {
        return this.builders.computeIfAbsent(pTag.comp_327(), location -> {
            this.existingFileHelper.trackGenerated(location, this.resourceType);
            return new class_3494.class_3495();
        });
    }

    public record TagAppender<T>(String modID, class_3494.class_3495 internalBuilder, Function<T, class_2960> keyGetter) {
        public TagAppender<T> add(T value) {
            this.internalBuilder.method_26784(this.keyGetter.apply(value), this.modID);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(T ... values) {
            Stream.of(values).map(this.keyGetter).forEach(tagId -> this.internalBuilder.method_26784(tagId, this.modID));
            return this;
        }

        public TagAppender<T> add(class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.internalBuilder.method_26784(id, this.modID);
            }
            return this;
        }

        public TagAppender<T> addOptional(class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.internalBuilder.method_34891(id, this.modID);
            }
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> addTag(class_6862<T> ... tags) {
            for (class_6862<T> tag : tags) {
                this.internalBuilder.method_26787(tag.comp_327(), this.modID);
            }
            return this;
        }

        public TagAppender<T> addOptionalTag(class_2960 ... tags) {
            for (class_2960 tag : tags) {
                this.internalBuilder.method_34892(tag, this.modID);
            }
            return this;
        }

        public TagAppender<T> replace() {
            return this.replace(true);
        }

        public TagAppender<T> replace(boolean value) {
            ((FabricTagBuilder)this.internalBuilder).fabric_setReplace(value);
            return this;
        }

        public TagAppender<T> remove(T entry) {
            return this.remove(this.keyGetter.apply(entry));
        }

        @SafeVarargs
        public final TagAppender<T> remove(T first, T ... entries) {
            this.remove(first);
            for (T entry : entries) {
                this.remove(entry);
            }
            return this;
        }

        public TagAppender<T> remove(class_2960 location) {
            throw new RuntimeException("TODO: Port unsupported!");
        }

        public TagAppender<T> remove(class_2960 first, class_2960 ... locations) {
            this.remove(first);
            for (class_2960 location : locations) {
                this.remove(location);
            }
            return this;
        }

        public TagAppender<T> remove(class_6862<T> tag) {
            throw new RuntimeException("TODO: Port unsupported!");
        }

        @SafeVarargs
        public final TagAppender<T> remove(class_6862<T> first, class_6862<T> ... tags) {
            this.remove(first);
            for (class_6862<T> tag : tags) {
                this.remove(tag);
            }
            return this;
        }
    }
}

