/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.utils.GenericTagUtil;

public class UpdateModifiersPacket
implements IThreadsafePacket {
    private final Map<ModifierId, Modifier> allModifiers;
    private final Map<class_2960, class_3494<Modifier>> tags;
    private Collection<Modifier> modifiers;
    private Map<ModifierId, ModifierId> redirects;

    private void ensureCalculated() {
        if (this.modifiers == null || this.redirects == null) {
            ImmutableList.Builder modifiers = ImmutableList.builder();
            ImmutableMap.Builder redirects = ImmutableMap.builder();
            for (Map.Entry<ModifierId, Modifier> entry : this.allModifiers.entrySet()) {
                Modifier mod;
                ModifierId id = entry.getKey();
                if (id.equals((Object)(mod = entry.getValue()).getId())) {
                    modifiers.add((Object)mod);
                    continue;
                }
                redirects.put((Object)id, (Object)mod.getId());
            }
            this.modifiers = modifiers.build();
            this.redirects = redirects.build();
        }
    }

    private static Modifier getModifier(Map<ModifierId, Modifier> modifiers, ModifierId id) {
        Modifier modifier = ModifierManager.INSTANCE.getStatic(id);
        if (modifier == ModifierManager.INSTANCE.getDefaultValue() && (modifier = modifiers.get((Object)id)) == null) {
            throw new DecoderException("Unknown modifier " + id);
        }
        return modifier;
    }

    public UpdateModifiersPacket(class_2540 buffer) {
        int i;
        int size = buffer.method_10816();
        HashMap<ModifierId, Modifier> modifiers = new HashMap<ModifierId, Modifier>();
        for (i = 0; i < size; ++i) {
            ModifierId id2 = new ModifierId(buffer.method_10800(Short.MAX_VALUE));
            Modifier modifier = (Modifier)ModifierManager.MODIFIER_LOADERS.fromNetwork(buffer);
            modifier.setId(id2);
            modifiers.put(id2, modifier);
        }
        size = buffer.method_10816();
        for (i = 0; i < size; ++i) {
            ModifierId from = new ModifierId(buffer.method_10800(Short.MAX_VALUE));
            modifiers.put(from, UpdateModifiersPacket.getModifier(modifiers, new ModifierId(buffer.method_10800(Short.MAX_VALUE))));
        }
        this.allModifiers = modifiers;
        this.tags = GenericTagUtil.decodeTags(buffer, id -> UpdateModifiersPacket.getModifier(modifiers, new ModifierId((class_2960)id)));
    }

    public void encode(class_2540 buffer) {
        this.ensureCalculated();
        buffer.method_10804(this.modifiers.size());
        for (Modifier modifier : this.modifiers) {
            buffer.method_10812((class_2960)modifier.getId());
            ModifierManager.MODIFIER_LOADERS.toNetwork((GenericLoaderRegistry.IHaveLoader)modifier, buffer);
        }
        buffer.method_10804(this.redirects.size());
        for (Map.Entry entry : this.redirects.entrySet()) {
            buffer.method_10812((class_2960)entry.getKey());
            buffer.method_10812((class_2960)entry.getValue());
        }
        GenericTagUtil.encodeTags(buffer, Modifier::getId, this.tags);
    }

    public void handleThreadsafe(ISimplePacket.Context context) {
        ModifierManager.INSTANCE.updateModifiersFromServer(this.allModifiers, this.tags);
    }

    public UpdateModifiersPacket(Map<ModifierId, Modifier> allModifiers, Map<class_2960, class_3494<Modifier>> tags) {
        this.allModifiers = allModifiers;
        this.tags = tags;
    }
}

