/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.List;
import net.minecraft.class_2561;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class IncrementalModifier
extends Modifier {
    @Override
    public class_2561 getDisplayName(IToolStackView tool, int level) {
        int amount;
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this.getId());
        class_2561 name = this.getDisplayName(level);
        if (neededPerLevel > 0 && (amount = this.getAmount(tool)) < neededPerLevel) {
            return name.method_27661().method_27693(": " + amount + " / " + neededPerLevel);
        }
        return name;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.getId());
    }

    public static int getAmount(IModDataView persistentData, ModifierId modifier) {
        if (persistentData.contains(modifier, 99)) {
            return persistentData.getInt(modifier);
        }
        return ModifierRecipeLookup.getNeededPerLevel(modifier);
    }

    public static int getAmount(IToolContext tool, ModifierId modifier) {
        return IncrementalModifier.getAmount(tool.getPersistentData(), modifier);
    }

    public int getAmount(IModDataView persistentData) {
        return IncrementalModifier.getAmount(persistentData, this.getId());
    }

    public int getAmount(IToolContext tool) {
        return IncrementalModifier.getAmount(tool, this.getId());
    }

    public float getScaledLevel(IModDataView persistentData, int level) {
        if (level <= 0) {
            return 0.0f;
        }
        int neededPerLevel = ModifierRecipeLookup.getNeededPerLevel(this.getId());
        if (neededPerLevel > 0) {
            return (float)level + (float)(this.getAmount(persistentData) - neededPerLevel) / (float)neededPerLevel;
        }
        return level;
    }

    @Override
    public float getEffectiveLevel(IToolContext tool, int level) {
        return this.getScaledLevel(tool.getPersistentData(), level);
    }

    @Deprecated
    public float getScaledLevel(IToolContext tool, int level) {
        return this.getScaledLevel(tool.getPersistentData(), level);
    }

    public static void setAmount(ModDataNBT persistentData, ModifierId modifier, int amount) {
        persistentData.putInt(modifier, amount);
    }

    protected void addDamageTooltip(IToolStackView tool, int level, float levelAmount, List<class_2561> tooltip) {
        this.addDamageTooltip(tool, this.getScaledLevel(tool, level) * levelAmount, tooltip);
    }
}

