/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.BitSet;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class InventoryModifier
extends Modifier
implements ToolInventoryCapability.IInventoryModifier {
    protected static final BiFunction<class_2487, String, class_2499> GET_COMPOUND_LIST = (nbt, name) -> nbt.method_10554(name, 10);
    private static final ValidatedResult HAS_ITEMS = ValidatedResult.failure(TConstruct.makeTranslationKey("modifier", "inventory_cannot_remove"), new Object[0]);
    protected static final String TAG_SLOT = "Slot";
    @Nullable
    private final class_2960 inventoryKey;
    protected final int slotsPerLevel;

    public InventoryModifier(int slotsPerLevel) {
        this(null, slotsPerLevel);
    }

    protected class_2960 getInventoryKey() {
        return this.inventoryKey == null ? this.getId() : this.inventoryKey;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ToolInventoryCapability.addSlots(volatileData, this.getSlots(context, level));
    }

    protected ValidatedResult validateForMaxSlots(IToolStackView tool, int maxSlots) {
        class_2499 listNBT;
        class_2960 key;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(key = this.getInventoryKey(), 9) && !(listNBT = persistentData.get(key, GET_COMPOUND_LIST)).isEmpty()) {
            int i;
            if (maxSlots == 0) {
                return HAS_ITEMS;
            }
            BitSet freeSlots = new BitSet(maxSlots);
            freeSlots.set(0, maxSlots - 1, true);
            for (i = 0; i < listNBT.size(); ++i) {
                freeSlots.set(listNBT.method_10602(i).method_10550(TAG_SLOT), false);
            }
            for (i = 0; i < listNBT.size(); ++i) {
                class_2487 compoundNBT = listNBT.method_10602(i);
                if (compoundNBT.method_10550(TAG_SLOT) < maxSlots) continue;
                int free = freeSlots.stream().findFirst().orElse(-1);
                if (free == -1) {
                    return HAS_ITEMS;
                }
                freeSlots.set(free, false);
                compoundNBT.method_10569(TAG_SLOT, free);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        return this.validateForMaxSlots(tool, level == 0 ? 0 : this.getSlots(tool, level));
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.getInventoryKey());
    }

    @Override
    public class_1799 getStack(IToolStackView tool, int level, int slot) {
        ModDataNBT modData = tool.getPersistentData();
        class_2960 key = this.getInventoryKey();
        if (slot < this.getSlots(tool, level) && modData.contains(key, 9)) {
            class_2499 list = tool.getPersistentData().get(key, GET_COMPOUND_LIST);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 compound = list.method_10602(i);
                if (compound.method_10550(TAG_SLOT) != slot) continue;
                return class_1799.method_7915((class_2487)compound);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public void setStack(IToolStackView tool, int level, int slot, class_1799 stack) {
        if (slot < this.getSlots(tool, level)) {
            class_2499 list;
            class_2960 key;
            ModDataNBT modData = tool.getPersistentData();
            if (modData.contains(key = this.getInventoryKey(), 9)) {
                list = modData.get(key, GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 compound = list.method_10602(i);
                    if (compound.method_10550(TAG_SLOT) != slot) continue;
                    if (stack.method_7960()) {
                        list.method_10536(i);
                    } else {
                        compound.method_10541().clear();
                        stack.method_7953(compound);
                        compound.method_10569(TAG_SLOT, slot);
                    }
                    return;
                }
            } else {
                if (stack.method_7960()) {
                    return;
                }
                list = new class_2499();
                modData.put(key, (class_2520)list);
            }
            if (!stack.method_7960()) {
                list.add((Object)InventoryModifier.write(stack, slot));
            }
        }
    }

    public int getSlots(IToolContext tool, int level) {
        return level * this.slotsPerLevel;
    }

    @Override
    public final int getSlots(IToolStackView tool, int level) {
        return this.getSlots((IToolContext)tool, level);
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return InventoryModifier.tryModuleMatch(type, ToolInventoryCapability.IInventoryModifier.class, this);
    }

    protected static class_2487 write(class_1799 stack, int slot) {
        class_2487 compound = new class_2487();
        stack.method_7953(compound);
        compound.method_10569(TAG_SLOT, slot);
        return compound;
    }

    public InventoryModifier(@Nullable class_2960 inventoryKey, int slotsPerLevel) {
        this.inventoryKey = inventoryKey;
        this.slotsPerLevel = slotsPerLevel;
    }
}

